(function() {
  var Installer, e;

  $.evalFile("" + (File($.fileName).path) + "/files/config.jsx");

  Installer = (function() {
    Installer.prototype.logString = '';

    Installer.prototype.isWindows = function() {
      return $.os.match(/windows/i);
    };

    Installer.prototype.isMac = function() {
      return !this.isWindows();
    };

    function Installer(config) {
      this.config = config;
      this.configure();
      this.copyFiles('CEP');
      this.copyFiles('CEPServiceManager4');
      this.teardown();
    }

    Installer.prototype.configure = function(config) {
      var k, v, _ref;
      if (this.config == null) {
        throw Error("Config is not defined");
      }
      _ref = this.config;
      for (k in _ref) {
        v = _ref[k];
        this[k] = v;
      }
      this.CURRENT_PATH = File($.fileName).path;
      this.LOG_FILE_POINTER = this.createNewLogFile();
      this.CURRENT_APP_NAME = app.name.match(/illustrator/i) ? "Illustrator" : "Photoshop";
      this.CURRENT_APP_VERSION = parseInt(app.version.split('.')[0]);
      this.SRC_POINTER = Folder("" + this.CURRENT_PATH + "/" + this.RELATIVE_SRC_PATH);
      return this.log("Product: " + this.PRODUCT_NAME + "\nVersion: " + this.PRODUCT_VERSION + "\nEdition: " + this.PRODUCT_EDITION + "\nApp Name: " + this.CURRENT_APP_VERSION + "\nApp Version: " + app.version + "\nOperating system: " + $.os + "\nLocale: " + $.locale + "\nInstallation source: " + this.CURRENT_PATH);
    };

    Installer.prototype.teardown = function() {
      alert("Installation successful\n\nPlease restart " + this.CURRENT_APP_NAME + " to use " + this.PRODUCT_NAME + ".");
      return this.log("Installation successful");
    };

    Installer.prototype.rm = function(obj) {
      var file, path, _i, _len, _ref;
      if (obj instanceof File || obj.getFiles().length === 0) {
        path = obj.fsName;
        if (obj.remove()) {
          return this.log("rm " + path);
        }
        this.error("Failed to delete " + path + " (" + obj.error + ")\nPlease delete it manually and try installation again.");
      }
      _ref = obj.getFiles().reverse();
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        file = _ref[_i];
        arguments.callee.call(this, file);
      }
      arguments.callee.call(this, obj);
      return true;
    };

    Installer.prototype.cp = function(src, dest) {
      var file, isFile, newDest, path, _i, _len, _ref;
      if (src instanceof File) {
        if (src.copy(dest)) {
          return this.log("cp " + src.fsName + " -> " + dest.fsName);
        }
        this.error("Fail: cp " + src.fsName + " -> " + dest.fsName + " (" + src.error + ")");
      }
      if (!dest.create()) {
        this.error("Failed to create " + dest.fsName + "\n\nYou may need to install GuideGuide manually\nhttp://guideguide.me/documentation/installation-manual/");
      }
      _ref = src.getFiles();
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        file = _ref[_i];
        isFile = file instanceof File;
        path = "" + (encodeURI(dest.fsName)) + "/" + file.name;
        newDest = isFile ? File(path) : Folder(path);
        arguments.callee.apply(this, [file, newDest]);
      }
      return true;
    };

    Installer.prototype.error = function(msg) {
      this.log(msg);
      throw Error(msg);
    };

    Installer.prototype.copyFiles = function(cepFolder) {
      var path, pointer;
      path = "" + Folder.userData + "/Adobe/" + cepFolder + "/extensions";
      pointer = Folder("" + path + "/" + this.PRODUCT_EDITION);
      if (pointer.exists) {
        this.rm(pointer);
      }
      return this.cp(this.SRC_POINTER, pointer);
    };

    Installer.prototype.log = function(msg) {
      var file;
      file = this.LOG_FILE_POINTER;
      if (!file.open('e')) {
        throw Error("Unable to open log file");
      }
      file.seek(0, 2);
      if (!file.writeln(msg)) {
        throw Error("Unable to write log file");
      }
      return true;
    };

    Installer.prototype.createNewLogFile = function() {
      var file;
      file = new File("" + this.CURRENT_PATH + "/" + this.PRODUCT_NAME + ".log");
      if (!file.open('w')) {
        throw Error("Unable to create log file");
      }
      if (this.isMac()) {
        file.lineFeed = 'unix';
      }
      file.encoding = "UTF8";
      return file;
    };

    return Installer;

  })();

  try {
    new Installer($.GuideGuideData);
  } catch (_error) {
    e = _error;
    alert("Installation failed:\n" + e + "\n\nA log has been created in the folder that contains the install script.\n\nFor troubleshooting tips, see\nguideguide.me/documentation/installation/");
  }

}).call(this);
