-----------------------------------------
--- file:		ragdoll-on-demand.lua ---
--- version:	1.3					  ---
--- author:		sakratt				  ---
-----------------------------------------

--- SETTINGS ---
rod_toggle_key_code = 85
rod_toggle_mode = false -- Whether to toggle the ragdoll or invoke it
rod_lifeless_ragdoll = false -- Whether the ragdoll is completely inanimate









--- RAGDOLL ON DEMAND ---
local ragdollOnDemand = {}
local justInvoked = false
local toggled = false;

function ragdollOnDemand.tick()
	local playerPed = PLAYER.PLAYER_PED_ID()
	local player = PLAYER.GET_PLAYER_PED(playerPed)
	if not ENTITY.DOES_ENTITY_EXIST(playerPed) then return end

	if get_key_pressed(rod_toggle_key_code) then
		if not justInvoked then
			if (rod_toggle_mode) then
				toggled = not toggled
			elseif (not PED.IS_PED_RAGDOLL(playerPed)) then
				ragdollPed(playerPed)
			end
		end
		justInvoked = true
	else
		justInvoked = false
	end
	if toggled then
		ragdollPed(playerPed)
	end
end

function ragdollPed(ped)
	local magicBool = not rod_lifeless_ragdoll
	local magicNumber = 0
	if not rod_lifeless_ragdoll then
		magicNumber = 100
	end
	PED.SET_PED_CAN_RAGDOLL(ped, true)
	PED.SET_PED_TO_RAGDOLL(ped, magicNumber, magicNumber, magicNumber, magicBool, magicBool, magicBool)
end

return ragdollOnDemand