; bp.nsi
;
; This script is based on example1.nsi, but it remember the directory, 
; has uninstall support and (optionally) installs start menu shortcuts.
;
; It will install makensisw.exe into a directory that the user selects,

;--------------------------------

; The name of the installer
Name "Ballpark 3DX"

; The file to write
OutFile "ballpark_3dx_install.exe"

; The default installation directory
InstallDir $PROGRAMFILES\BallPark3DX

; Registry key to check for directory (so if you install again, it will 
; overwrite the old one automatically)
InstallDirRegKey HKLM "Software\BallPark3DX" "Install_Dir"

;--------------------------------

; Pages

Page components
Page directory
Page instfiles

LoadLanguageFile "${NSISDIR}\Contrib\Language files\German.nlf"

UninstPage uninstConfirm
UninstPage instfiles

;--------------------------------

; The stuff to install
Section "BallPark 3DX"

  SectionIn RO
  
  ; Set output path to the installation directory.
  SetOutPath $INSTDIR
  
  ; Put file there
  File "*.*"
  SetOutPath $INSTDIR\adatok  
  File "adatok\*.*"
  SetOutPath $INSTDIR\adatok\3dx
  File "adatok\3dx\*.*"
  SetOutPath $INSTDIR\adatok\cursors
  File "adatok\cursors\*.*"
  SetOutPath $INSTDIR\adatok\icons
  File "adatok\icons\*.*"
  SetOutPath $INSTDIR\adatok\kepek_ger
  File "adatok\kepek_ger\*.*"  
  SetOutPath $INSTDIR\adatok\palyak_eng
  File "adatok\palyak_eng\*.*"
  SetOutPath $INSTDIR\adatok\palyak_hun
  File "adatok\palyak_hun\*.*"
  SetOutPath $INSTDIR
  
  ; Write the installation path into the registry
  WriteRegStr HKLM SOFTWARE\BallPark3DX "Install_Dir" "$INSTDIR"
  
  ; Write the uninstall keys for Windows
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\BallPark3DX" "DisplayName" "BallPark3DX"
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\BallPark3DX" "UninstallString" '"$INSTDIR\uninstall.exe"'
  WriteRegDWORD HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\BallPark3DX" "NoModify" 1
  WriteRegDWORD HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\BallPark3DX" "NoRepair" 1
  WriteUninstaller "uninstall.exe"
  
SectionEnd

; Optional section (can be disabled by the user)
Section "Start Menu Shortcuts"

  CreateDirectory "$SMPROGRAMS\BallPark3DX"
  CreateShortCut "$SMPROGRAMS\BallPark3DX\Uninstall.lnk" "$INSTDIR\uninstall.exe" "" "$INSTDIR\uninstall.exe" 0
  CreateShortCut "$SMPROGRAMS\BallPark3DX\BallPark 3DX.lnk" "$INSTDIR\ballpark_3dx.exe" "" "$INSTDIR\ballpark_3dx.exe" 0
  
SectionEnd

; Optional section (can be disabled by the user)
Section "Desktop Icon"
  
  CreateShortCut "$DESKTOP\BallPark 3DX.lnk" "$INSTDIR\ballpark_3dx.exe" "" "$INSTDIR\ballpark_3dx.exe" 0
  
SectionEnd

;--------------------------------

; Uninstaller

Section "Uninstall"
  
  ; Remove registry keys
  DeleteRegKey HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\Ballpark3DX"
  DeleteRegKey HKLM SOFTWARE\Ballpark3DX

  ; Remove files and uninstaller   
  Delete $INSTDIR\adatok\3dx\*.*
  Delete $INSTDIR\adatok\cursors\*.*
  Delete $INSTDIR\adatok\icons\*.*
  Delete $INSTDIR\adatok\kepek_ger\*.*
  Delete $INSTDIR\adatok\palyak_eng\*.*
  Delete $INSTDIR\adatok\palyak_hun\*.*
  Delete $INSTDIR\adatok\*.*
  Delete $INSTDIR\*.*
  Delete $INSTDIR\uninstall.exe

  ; Remove shortcuts, if any
  Delete "$SMPROGRAMS\BallPark3DX\*.*"
  Delete "$DESKTOP\BallPark 3DX.lnk"

  ; Remove directories used
  RMDir "$SMPROGRAMS\Ballpark3DX"
  RMDir "$INSTDIR\adatok\3dx"
  RMDir "$INSTDIR\adatok\cursors"
  RMDir "$INSTDIR\adatok\icons"
  RMDir "$INSTDIR\adatok\kepek_ger"
  RMDir "$INSTDIR\adatok\palyak_eng"
  RMDir "$INSTDIR\adatok\palyak_hun"
  RMDir "$INSTDIR\adatok"
  RMDir "$INSTDIR"

SectionEnd