Script.ReloadScript( "SCRIPTS/Entities/actor/BasicActor.lua");
Script.ReloadScript( "SCRIPTS/Entities/AI/Shared/BasicAI.lua");

Juggernaut_x =
{
	AnimationGraph = "UL_Zombie_FullBody_Freaks.xml",

	foreignCollisionDamageMult = 0.1,
	vehicleCollisionDamageMult = 0.0,

    physicsParams =
    {
        Living = {
    	    mass = 800,
    	}
    },

  colliderEnergyScale = 10,
  colliderRagdollScale = 150,

 	PropertiesInstance = {
 		AITerritoryAndWave = {
			aiterritory_Territory = "<None>",
			aiwave_Wave           = "<None>",
		},
	},

	Properties =
	{
		soclasses_SmartObjectClass = "Juggernaut",
		StateMachineData = "",
		voiceType = "enemy",
		esBehaviorSelectionTree = "ST_Freak_Juggernaut",
		fileModel = "characters/freaks/juggernaut/juggernaut.cdf",
		Damage =
		{
		  bNoGrab = 0,
			bNoDeath = 0,
			FallPercentage = 0,
			FallSleepTime = 2,
			health = 2000,
		},
		distanceToHideFrom = 3,
		preferredCombatDistance = 20,		-- preferred combat distance from the target
        -- UL Begin SL Switch default faction to Zombies
		esFaction = "Zombies",
        -- UL End
		equip_EquipmentPack = "DefaultAI",
		CharacterSounds =
		{
			footstepEffect = "footstep_juggernaut",		-- Footstep mfx library to use
			remoteFootstepEffect = "footstep",		-- Footstep mfx library to use for remote players
			bFootstepGearEffect = 0,				-- This plays a sound from materialfx
			footstepIndGearAudioSignal_Walk = "Player_Footstep_Gear_Walk",   -- This directly plays the specified audiosignal on every footstep
			footstepIndGearAudioSignal_Run = "Player_Footstep_Gear_Run",	-- This directly plays the specified audiosignal on every footstep
			foleyEffect = "foley_player",			-- Foley signal effect name
		},
	},

	gameParams =
	{
        stateMachine = "libs/StateMachines/Freak_Juggernaut/General.xml",

		inertia = 10.0, --the more, the faster the speed change: 1 is very slow, 10 is very fast already
		inertiaAccel = 0.0,

		backwardMultiplier = 0.5,--speed is multiplied by this ammount when going backward

		stance =
		{
			{
				stanceId = STANCE_STAND,
				normalSpeed = 1.0,
				maxSpeed = 15.0,
				heightCollider = 1.2,
				heightPivot = 0.0,
				size = {x=0.65,y=0.65,z=0.3},
				modelOffset = {x=0,y=-0.0,z=0},
				viewOffset = {x=0,y=0.10,z=1.625},
				weaponOffset = {x=0.2,y=0.0,z=1.35},
				leanLeftViewOffset = {x=-0.5,y=0.10,z=1.525},
				leanRightViewOffset = {x=0.5,y=0.10,z=1.525},
				leanLeftWeaponOffset = {x=-0.45,y=0.0,z=1.30},
				leanRightWeaponOffset = {x=0.65,y=0.0,z=1.30},
				name = "combat",
				useCapsule = 1,
			},
		},
	},


	-- the AI movement ability
	AIMovementAbility =
	{
		pathFindPrediction = 0.5,		-- predict the start of the path finding in the future to prevent turning back when tracing the path.
		allowEntityClampingByAnimation = 1,
		usePredictiveFollowing = 1,
		walkSpeed = 2.0, -- set up for humans
		runSpeed = 4.0,
		sprintSpeed = 6.4,
		b3DMove = 0,
		pathType = "AIPATH_DEFAULT",
		pathLookAhead = 1,
		pathRadius = 0.4,
		pathSpeedLookAheadPerSpeed = -1.5,
		cornerSlowDown = 0.75,
		maxAccel = 3.0,
		maxDecel = 8.0,
		maneuverSpeed = 1.5,
		velDecay = 0.5,
		minTurnRadius = 0,	-- meters
		maxTurnRadius = 3,	-- meters
		maneuverTrh = 2.0,  -- when cross(dir, desiredDir) > this use manouvering
		resolveStickingInTrace = 1,
		pathRegenIntervalDuringTrace = 4,
		lightAffectsSpeed = 1,

		-- These are actually aiparams (as they may be changed during game and need to get serialized),
		-- but defined here so that designers do not try to change them.
		lookIdleTurnSpeed = 30,
		lookCombatTurnSpeed = 50,
		aimTurnSpeed = -1, --120,
		fireTurnSpeed = -1, --120,

		-- Adjust the movement speed based on the angel between body dir and move dir.
		directionalScaleRefSpeedMin = 1.0,
		directionalScaleRefSpeedMax = 8.0,

	  AIMovementSpeeds =
	  {
			Relaxed =
			{
				Slow =		{ 0.73, 0.73, 0.73 },
				Walk =		{ 0.73, 0.73, 0.73 },
				Run =		{ 2.49, 2.49, 2.49 },
			},
			Combat =
			{
				Slow =		{ 0.73, 0.73, 0.73 },
				Walk =		{ 0.73, 0.73, 0.73 },
				Run =		{ 2.49, 2.49, 2.49 },
				Sprint =	{ 2.49, 2.49, 2.49 },
			},
	  },
	},

	AI_changeCoverLastTime = 0,
	AI_changeCoverInterval = 7,


	--melee stuff
	melee =
	{
		damageRadius = 1.1,								-- size of the damage box.
	},
}

function Juggernaut_x:OnRevive()
end

function Juggernaut_x:GetHeadShotEffect()
    return "Class3Characters.Juggernaut.head_burst"
end
