Script.ReloadScript( "SCRIPTS/Entities/actor/BasicActor.lua");
Script.ReloadScript( "SCRIPTS/Entities/AI/Shared/BasicAI.lua");

FreshGrunt_x =
{
	AnimationGraph = "UL_Zombie_FullBody.xml",

	colliderEnergyScale = 10,
	colliderRagdollScale = 150,
  	foreignCollisionDamageMult = 1.0, -- multiplies damage done TO vehicles when collisions occur

 	PropertiesInstance = {
 		AITerritoryAndWave = {
			aiterritory_Territory = "<None>",
			aiwave_Wave           = "<None>",
		},
	},

	Properties =
	{
		soclasses_SmartObjectClass = "Zombie",
		StateMachineData = "",
		voiceType = "enemy",
		fileModel = "",
		Damage =
		{
		  bNoGrab = 0,
			bNoDeath = 0,
			FallPercentage = 20,
			FallSleepTime = 2,
			health = 25,
		},
		distanceToHideFrom = 3,
		preferredCombatDistance = 20,		-- preferred combat distance from the target
        -- UL Begin SL Switch default faction to Zombies
		esFaction = "Zombies",
        -- UL End
		equip_EquipmentPack = "",
		CharacterSounds =
		{
			footstepEffect = "footstep_zed",		-- Footstep mfx library to use
			remoteFootstepEffect = "footstep",		-- Footstep mfx library to use for remote players
			bFootstepGearEffect = 0,				-- This plays a sound from materialfx
			footstepIndGearAudioSignal_Walk = "Player_Footstep_Gear_Walk",   -- This directly plays the specified audiosignal on every footstep
			footstepIndGearAudioSignal_Run = "Player_Footstep_Gear_Run",	-- This directly plays the specified audiosignal on every footstep
			foleyEffect = "foley_player",			-- Foley signal effect name
		},
	},

	gameParams =
	{
        stateMachine = "Libs/StateMachines/Zombie/General.xml",

		inertia = 10.0, --the more, the faster the speed change: 1 is very slow, 10 is very fast already
		inertiaAccel = 0.0,

		backwardMultiplier = 0.5,--speed is multiplied by this ammount when going backward

		stance =
		{
		    {
		        stanceId = STANCE_STAND,

		        heightCollider = 1.0,
		        heightPivot = 0.0,
				size = {x=0.375,y=0.375,z=0.4},
		        useCapsule = 1,
		    },
		},
	},


	-- the AI movement ability
	AIMovementAbility =
	{
		pathFindPrediction = 0.5,		-- predict the start of the path finding in the future to prevent turning back when tracing the path.
		allowEntityClampingByAnimation = 1,
		usePredictiveFollowing = 1,
		walkSpeed = 2.0, -- set up for humans
		runSpeed = 4.0,
		sprintSpeed = 6.4,
		b3DMove = 0,
		pathType = "AIPATH_DEFAULT",
		pathLookAhead = 1,
		pathRadius = 0.4,
		pathSpeedLookAheadPerSpeed = -1.5,
		cornerSlowDown = 0.75,
		maxAccel = 3.0,
		maxDecel = 8.0,
		maneuverSpeed = 1.5,
		velDecay = 0.5,
		minTurnRadius = 0,	-- meters
		maxTurnRadius = 3,	-- meters
		maneuverTrh = 2.0,  -- when cross(dir, desiredDir) > this use manouvering
		resolveStickingInTrace = 1,
		pathRegenIntervalDuringTrace = 4,
		lightAffectsSpeed = 1,

		-- These are actually aiparams (as they may be changed during game and need to get serialized),
		-- but defined here so that designers do not try to change them.
		lookIdleTurnSpeed = 30,
		lookCombatTurnSpeed = 50,
		aimTurnSpeed = -1, --120,
		fireTurnSpeed = -1, --120,

		-- Adjust the movement speed based on the angel between body dir and move dir.
		directionalScaleRefSpeedMin = 1.0,
		directionalScaleRefSpeedMax = 8.0,

	  AIMovementSpeeds =
	  {
			Relaxed =
			{
				Slow =		{ 1.0, 1.0,1.9 },
				Walk =		{ 1.3, 1.0,1.9 },
				Run =			{ 4.5, 2.0,7.2 },
			},
			Combat =
			{
				Slow =		{ 0.8, 0.8,1.3 },
				Walk =		{ 1.3, 0.8,1.3 },
				Run =			{ 4.5, 2.3,6.0 },
				Sprint =	{ 6.5, 2.3,6.5 },
			},
			Crouch =
			{
				Slow =		{ 0.5, 0.3,1.3 },
				Walk =		{ 0.9, 0.3,1.3 },
				Run =			{ 3.5, 2.7,5.5 },
			},
			Stealth =
			{
				Slow =		{ 0.8, 0.7,1.0 },
				Walk =		{ 0.9, 0.7,1.0 },
				Run =			{ 3.5, 2.7,5.5 },
			},
			Cover =
			{
				Slow =		{ 1.0, 1.0, 1.0 },
				Walk =		{ 1.9, 1.9, 1.9 },
				Run =			{ 7.0, 7.0, 7.0 },
				Sprint =	{ 7.0, 7.0, 7.0 },
			},
			Prone =
			{
				Slow =		{ 0.4, 0.4,0.5 },
				Walk =		{ 0.5, 0.4,0.5 },
				Run =			{ 0.5, 0.4,0.5 },
			},
			Swim =
			{
				Slow =		{ 0.5, 0.6,0.7 },
				Walk =		{ 0.6, 0.6,0.7 },
				Run =			{ 3.0, 2.9,4.3 },
			},
	  },
	},

	AI_changeCoverLastTime = 0,
	AI_changeCoverInterval = 7,


	--melee stuff
	melee =
	{
		damageRadius = 1.1,								-- size of the damage box.
	},
}
function FreshGrunt_x:KillableByCollision()
	return true;
end

function FreshGrunt_x:OnRevive()
end

function FreshGrunt_x:GetHeadShotEffect()
    return "Class3Bullets.zed_hits.sever_head"
end