Script.ReloadScript( "SCRIPTS/Entities/actor/BasicActor.lua");
Script.ReloadScript( "SCRIPTS/Entities/AI/Shared/BasicAI.lua");

Feral_x =
{
	AnimationGraph = "UL_Zombie_FullBody_Freaks.xml",

  colliderEnergyScale = 10,
  colliderRagdollScale = 150,

 	PropertiesInstance = {
 		AITerritoryAndWave = {
			aiterritory_Territory = "<None>",
			aiwave_Wave           = "<None>",
		},
	},

	Properties =
	{
		soclasses_SmartObjectClass = "Feral",
		StateMachineData = "",
		voiceType = "enemy",
		esBehaviorSelectionTree = "ST_Freak_Feral",
		fileModel = "characters/freaks/feral/feral.cdf",
		Damage =
		{
		  bNoGrab = 0,
			bNoDeath = 0,
			FallPercentage = 20,
			FallSleepTime = 2,
			health = 250,
		},
		distanceToHideFrom = 3,
		preferredCombatDistance = 20,		-- preferred combat distance from the target
        -- UL Begin SL Switch default faction to Zombies
		esFaction = "Zombies",
        -- UL End
		equip_EquipmentPack = "DefaultAI",
		CharacterSounds =
		{
			footstepEffect = "footstep_feral",		-- Footstep mfx library to use
			remoteFootstepEffect = "footstep",		-- Footstep mfx library to use for remote players
			bFootstepGearEffect = 0,				-- This plays a sound from materialfx
			footstepIndGearAudioSignal_Walk = "Player_Footstep_Gear_Walk",   -- This directly plays the specified audiosignal on every footstep
			footstepIndGearAudioSignal_Run = "Player_Footstep_Gear_Run",	-- This directly plays the specified audiosignal on every footstep
			foleyEffect = "foley_player",			-- Foley signal effect name
		},
	},

	gameParams =
	{
        stateMachine = "Libs/StateMachines/Freak_Feral/General.xml",

		inertia = 0.0, --the more, the faster the speed change: 1 is very slow, 10 is very fast already
		inertiaAccel = 0.0,

		backwardMultiplier = 0.5,--speed is multiplied by this ammount when going backward
	},


	-- the AI movement ability
	AIMovementAbility =
	{
		pathFindPrediction = 0.5,		-- predict the start of the path finding in the future to prevent turning back when tracing the path.
		allowEntityClampingByAnimation = 1,
		usePredictiveFollowing = 1,
		walkSpeed = 2.0, -- set up for humans
		runSpeed = 4.0,
		sprintSpeed = 6.4,
		b3DMove = 0,
		pathType = "AIPATH_DEFAULT",
		pathLookAhead = 1,
		pathRadius = 0.4,
		pathSpeedLookAheadPerSpeed = -1.5,
		cornerSlowDown = 0.75,
		maxAccel = 3.0,
		maxDecel = 8.0,
		maneuverSpeed = 1.5,
		velDecay = 0.5,
		minTurnRadius = 0,	-- meters
		maxTurnRadius = 3,	-- meters
		maneuverTrh = 2.0,  -- when cross(dir, desiredDir) > this use manouvering
		resolveStickingInTrace = 1,
		pathRegenIntervalDuringTrace = 4,
		lightAffectsSpeed = 1,

		-- These are actually aiparams (as they may be changed during game and need to get serialized),
		-- but defined here so that designers do not try to change them.
		lookIdleTurnSpeed = 30,
		lookCombatTurnSpeed = 50,
		aimTurnSpeed = -1, --120,
		fireTurnSpeed = -1, --120,

		-- Adjust the movement speed based on the angel between body dir and move dir.
		directionalScaleRefSpeedMin = 1.0,
		directionalScaleRefSpeedMax = 8.0,

	  AIMovementSpeeds =
	  {
			Relaxed =
			{
				Slow =		{ 2.6, 2.6, 2.6 },
				Walk =		{ 2.6, 2.6, 2.6 },
				Run =		{ 7.26, 6.0, 8.0 },
				Sprint =	{ 10.0, 7.26, 7.26 },
			},
			Combat =
			{
				Slow =		{ 2.6, 2.6, 2.6 },
				Walk =		{ 2.6, 2.6, 2.6 },
				Run =		{ 7.26, 6.0, 8.0 },
				Sprint =	{ 10.0, 7.26, 7.26 },
			},
	  },
	},

	AI_changeCoverLastTime = 0,
	AI_changeCoverInterval = 7,


	--melee stuff
	melee =
	{
		damageRadius = 1.1,								-- size of the damage box.
	},
}
function Feral_x:KillableByCollision()
	return true;
end

function Feral_x:OnRevive()
end

function Feral_x:GetHeadShotEffect()
    return "Class3Characters.Feral.head_burst"
end
