/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.transport.http.client;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import com.sun.xml.internal.ws.api.EndpointAddress;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.client.ClientTransportException;
import com.sun.xml.internal.ws.resources.ClientMessages;
import com.sun.xml.internal.ws.transport.Headers;
import com.sun.xml.internal.ws.transport.http.client.CookieJar;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.xml.bind.DatatypeConverter;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.ws.WebServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class HttpClientTransport {
    private static String LAST_ENDPOINT;
    private static boolean redirect;
    private static final int START_REDIRECT_COUNT = 3;
    private static int redirectCount;
    int statusCode;
    private final Map<String, List<String>> reqHeaders;
    private Map<String, List<String>> respHeaders = null;
    private OutputStream outputStream;
    private boolean https;
    private HttpURLConnection httpConnection = null;
    private EndpointAddress endpoint = null;
    private Packet context = null;
    private CookieJar cookieJar = null;
    private boolean isFailure = false;
    private final Integer chunkSize;

    public HttpClientTransport(@NotNull Packet packet, @NotNull Map<String, List<String>> map) {
        this.endpoint = packet.endpointAddress;
        this.context = packet;
        this.reqHeaders = map;
        this.chunkSize = (Integer)this.context.invocationProperties.get("com.sun.xml.internal.ws.transport.http.client.streaming.chunk.size");
    }

    public OutputStream getOutput() {
        try {
            this.createHttpConnection();
            this.sendCookieAsNeeded();
            if (this.requiresOutputStream()) {
                List<String> list;
                this.outputStream = this.httpConnection.getOutputStream();
                if (this.chunkSize != null) {
                    this.outputStream = new WSChunkedOuputStream(this.outputStream, this.chunkSize);
                }
                if ((list = this.reqHeaders.get("Content-Encoding")) != null && list.get(0).contains("gzip")) {
                    this.outputStream = new GZIPOutputStream(this.outputStream);
                }
            }
            this.httpConnection.connect();
        }
        catch (Exception exception) {
            throw new ClientTransportException(ClientMessages.localizableHTTP_CLIENT_FAILED(exception), (Throwable)exception);
        }
        return this.outputStream;
    }

    public void closeOutput() throws IOException {
        if (this.outputStream != null) {
            this.outputStream.close();
            this.outputStream = null;
        }
    }

    public InputStream getInput() {
        InputStream inputStream;
        try {
            inputStream = this.readResponse();
            String string = this.httpConnection.getContentEncoding();
            if (string != null && string.contains("gzip")) {
                inputStream = new GZIPInputStream(inputStream);
            }
        }
        catch (IOException iOException) {
            if (this.statusCode == 204 || this.isFailure && this.statusCode != 500) {
                try {
                    throw new ClientTransportException(ClientMessages.localizableHTTP_STATUS_CODE(this.statusCode, this.httpConnection.getResponseMessage()));
                }
                catch (IOException iOException2) {
                    throw new ClientTransportException(ClientMessages.localizableHTTP_STATUS_CODE(this.statusCode, iOException2));
                }
            }
            throw new ClientTransportException(ClientMessages.localizableHTTP_CLIENT_FAILED(iOException), (Throwable)iOException);
        }
        return inputStream;
    }

    public Map<String, List<String>> getHeaders() {
        if (this.respHeaders != null) {
            return this.respHeaders;
        }
        this.respHeaders = new Headers();
        this.respHeaders.putAll(this.httpConnection.getHeaderFields());
        return this.respHeaders;
    }

    protected InputStream readResponse() throws IOException {
        return this.isFailure ? this.httpConnection.getErrorStream() : this.httpConnection.getInputStream();
    }

    void checkResponseCode() {
        try {
            this.statusCode = this.httpConnection.getResponseCode();
            if (this.httpConnection.getResponseCode() == 500) {
                this.isFailure = true;
            } else {
                if (this.httpConnection.getResponseCode() == 401) {
                    throw new ClientTransportException(ClientMessages.localizableHTTP_CLIENT_UNAUTHORIZED(this.httpConnection.getResponseMessage()));
                }
                if (this.httpConnection.getResponseCode() == 404) {
                    throw new ClientTransportException(ClientMessages.localizableHTTP_NOT_FOUND(this.httpConnection.getResponseMessage()));
                }
                if (this.statusCode == 302 || this.statusCode == 301) {
                    this.isFailure = true;
                    if (!redirect || redirectCount <= 0) {
                        throw new ClientTransportException(ClientMessages.localizableHTTP_STATUS_CODE(this.statusCode, this.getStatusMessage()));
                    }
                } else {
                    if (this.statusCode < 200 || this.statusCode >= 303 && this.statusCode < 500) {
                        throw new ClientTransportException(ClientMessages.localizableHTTP_STATUS_CODE(this.statusCode, this.getStatusMessage()));
                    }
                    if (this.statusCode >= 500) {
                        this.isFailure = true;
                    }
                }
            }
        }
        catch (IOException iOException) {
            throw new WebServiceException(iOException);
        }
        this.saveCookieAsNeeded();
    }

    private String getStatusMessage() throws IOException {
        String string;
        int n = this.httpConnection.getResponseCode();
        String string2 = this.httpConnection.getResponseMessage();
        if ((n == 201 || n >= 300 && n != 304 && n < 400) && (string = this.httpConnection.getHeaderField("Location")) != null) {
            string2 = string2 + " - Location: " + string;
        }
        return string2;
    }

    protected void sendCookieAsNeeded() {
        Boolean bl = (Boolean)this.context.invocationProperties.get("javax.xml.ws.session.maintain");
        if (bl != null && bl.booleanValue()) {
            this.cookieJar = (CookieJar)this.context.invocationProperties.get("com.sun.xml.internal.ws.client.http.CookieJar");
            if (this.cookieJar == null) {
                this.cookieJar = new CookieJar();
                this.context.proxy.getRequestContext().put("com.sun.xml.internal.ws.client.http.CookieJar", this.cookieJar);
            }
            this.cookieJar.applyRelevantCookies(this.httpConnection);
        }
    }

    private void saveCookieAsNeeded() {
        if (this.cookieJar != null) {
            this.cookieJar.recordAnyCookies(this.httpConnection);
        }
    }

    private void createHttpConnection() throws IOException {
        Object object;
        Object object2;
        String string;
        String string2 = (String)this.context.invocationProperties.get("com.sun.xml.internal.ws.client.http.RedirectRequestProperty");
        if (string2 != null && string2.equalsIgnoreCase("false")) {
            redirect = false;
        }
        this.checkEndpoints();
        this.httpConnection = (HttpURLConnection)this.endpoint.openConnection();
        if (this.httpConnection instanceof HttpsURLConnection) {
            this.https = true;
            boolean bl = false;
            string = (String)this.context.invocationProperties.get("com.sun.xml.internal.ws.client.http.HostnameVerificationProperty");
            if (string != null && string.equalsIgnoreCase("true")) {
                bl = true;
            }
            if (!bl) {
                ((HttpsURLConnection)this.httpConnection).setHostnameVerifier(new HttpClientVerifier());
            }
            if ((object2 = (HostnameVerifier)this.context.invocationProperties.get("com.sun.xml.internal.ws.transport.https.client.hostname.verifier")) != null) {
                ((HttpsURLConnection)this.httpConnection).setHostnameVerifier((HostnameVerifier)object2);
            }
            if ((object = (SSLSocketFactory)this.context.invocationProperties.get("com.sun.xml.internal.ws.transport.https.client.SSLSocketFactory")) != null) {
                ((HttpsURLConnection)this.httpConnection).setSSLSocketFactory((SSLSocketFactory)object);
            }
        }
        this.writeBasicAuthAsNeeded(this.context, this.reqHeaders);
        this.httpConnection.setAllowUserInteraction(true);
        this.httpConnection.setDoOutput(true);
        this.httpConnection.setDoInput(true);
        String string3 = (String)this.context.invocationProperties.get("javax.xml.ws.http.request.method");
        string = string3 != null ? string3 : "POST";
        this.httpConnection.setRequestMethod(string);
        object2 = (Integer)this.context.invocationProperties.get("com.sun.xml.internal.ws.request.timeout");
        if (object2 != null) {
            this.httpConnection.setReadTimeout((Integer)object2);
        }
        if ((object = (Integer)this.context.invocationProperties.get("com.sun.xml.internal.ws.transport.http.client.streaming.chunk.size")) != null) {
            this.httpConnection.setChunkedStreamingMode((Integer)object);
        }
        for (Map.Entry<String, List<String>> entry : this.reqHeaders.entrySet()) {
            this.httpConnection.addRequestProperty(entry.getKey(), entry.getValue().get(0));
        }
    }

    public boolean isSecure() {
        return this.https;
    }

    private boolean checkForRedirect(int n) {
        return (n == 301 || n == 302) && redirect && redirectCount-- > 0;
    }

    private void checkEndpoints() {
        if (!LAST_ENDPOINT.equalsIgnoreCase(this.endpoint.toString())) {
            redirectCount = 3;
            LAST_ENDPOINT = this.endpoint.toString();
        }
    }

    private void writeBasicAuthAsNeeded(Packet packet, Map<String, List<String>> map) {
        String string;
        String string2 = (String)packet.invocationProperties.get("javax.xml.ws.security.auth.username");
        if (string2 != null && (string = (String)packet.invocationProperties.get("javax.xml.ws.security.auth.password")) != null) {
            StringBuffer stringBuffer = new StringBuffer(string2);
            stringBuffer.append(":");
            stringBuffer.append(string);
            String string3 = DatatypeConverter.printBase64Binary(stringBuffer.toString().getBytes());
            map.put("Authorization", Collections.singletonList("Basic " + string3));
        }
    }

    private boolean requiresOutputStream() {
        return !this.httpConnection.getRequestMethod().equalsIgnoreCase("GET") && !this.httpConnection.getRequestMethod().equalsIgnoreCase("HEAD") && !this.httpConnection.getRequestMethod().equalsIgnoreCase("DELETE");
    }

    @Nullable
    public String getContentType() {
        return this.httpConnection.getContentType();
    }

    static {
        try {
            JAXBContext.newInstance(new Class[0]).createUnmarshaller();
        }
        catch (JAXBException jAXBException) {
            // empty catch block
        }
        LAST_ENDPOINT = "";
        redirect = true;
        redirectCount = 3;
    }

    private static class HttpClientVerifier
    implements HostnameVerifier {
        private HttpClientVerifier() {
        }

        public boolean verify(String string, SSLSession sSLSession) {
            return true;
        }
    }

    private static final class WSChunkedOuputStream
    extends OutputStream {
        final OutputStream actual;
        final int chunkSize;

        WSChunkedOuputStream(OutputStream outputStream, int n) {
            this.actual = outputStream;
            this.chunkSize = n;
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            int n3;
            for (int i = 0; i < n2; i += n3) {
                n3 = n2 - i;
                if (n3 > this.chunkSize) {
                    n3 = this.chunkSize;
                }
                this.actual.write(byArray, n, n3);
                n += n3;
            }
        }

        public void write(byte[] byArray) throws IOException {
            this.write(byArray, 0, byArray.length);
        }

        public void write(int n) throws IOException {
            this.actual.write(n);
        }

        public void flush() throws IOException {
            this.actual.flush();
        }

        public void close() throws IOException {
            this.actual.close();
        }
    }
}

