/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.jnl;

import com.sun.deploy.config.JREInfo;
import com.sun.deploy.ui.AppInfo;
import com.sun.deploy.util.Trace;
import com.sun.deploy.xml.XMLAttributeBuilder;
import com.sun.deploy.xml.XMLNode;
import com.sun.deploy.xml.XMLNodeBuilder;
import com.sun.deploy.xml.XMLable;
import com.sun.javaws.exceptions.JNLPSigningException;
import com.sun.javaws.jnl.AppletDesc;
import com.sun.javaws.jnl.ApplicationDesc;
import com.sun.javaws.jnl.ExtensionDesc;
import com.sun.javaws.jnl.IconDesc;
import com.sun.javaws.jnl.InformationDesc;
import com.sun.javaws.jnl.InstallerDesc;
import com.sun.javaws.jnl.JARDesc;
import com.sun.javaws.jnl.JREDesc;
import com.sun.javaws.jnl.LDUpdater;
import com.sun.javaws.jnl.LaunchSelection;
import com.sun.javaws.jnl.LibraryDesc;
import com.sun.javaws.jnl.PackageDesc;
import com.sun.javaws.jnl.PropertyDesc;
import com.sun.javaws.jnl.ResourceVisitor;
import com.sun.javaws.jnl.ResourcesDesc;
import com.sun.javaws.jnl.UpdateDesc;
import java.net.MalformedURLException;
import java.net.URL;

public class LaunchDesc
implements XMLable {
    private String _specVersion;
    private String _version;
    private URL _home;
    private URL _codebase;
    private InformationDesc _information;
    private int _securiyModel;
    private UpdateDesc _update;
    private ResourcesDesc _resources;
    private int _launchType;
    private ApplicationDesc _applicationDesc;
    private AppletDesc _appletDesc;
    private LibraryDesc _libraryDesc;
    private InstallerDesc _installerDesc;
    private String _internalCommand;
    private String _source;
    private boolean _propsSet = false;
    private byte[] _bits;
    private JREInfo _selectedJRE = null;
    private JREInfo _homeJRE = null;
    private LaunchSelection.MatchJREIf _matchImpl = null;
    private boolean _signed = false;
    private LDUpdater _updater = null;
    public static final int SANDBOX_SECURITY = 0;
    public static final int ALLPERMISSIONS_SECURITY = 1;
    public static final int J2EE_APP_CLIENT_SECURITY = 2;
    public static final int APPLICATION_DESC_TYPE = 1;
    public static final int APPLET_DESC_TYPE = 2;
    public static final int LIBRARY_DESC_TYPE = 3;
    public static final int INSTALLER_DESC_TYPE = 4;
    public static final int INTERNAL_TYPE = 5;

    public LaunchDesc(String string, URL uRL, URL uRL2, String string2, InformationDesc informationDesc, int n, UpdateDesc updateDesc, ResourcesDesc resourcesDesc, int n2, ApplicationDesc applicationDesc, AppletDesc appletDesc, LibraryDesc libraryDesc, InstallerDesc installerDesc, String string3, String string4, byte[] byArray, LaunchSelection.MatchJREIf matchJREIf) {
        this._specVersion = string;
        this._version = string2;
        this._codebase = uRL;
        this._home = uRL2;
        this._information = informationDesc;
        this._securiyModel = n;
        this._update = updateDesc;
        this._resources = resourcesDesc;
        this._launchType = n2;
        this._applicationDesc = applicationDesc;
        this._appletDesc = appletDesc;
        this._libraryDesc = libraryDesc;
        this._installerDesc = installerDesc;
        this._internalCommand = string3;
        this._source = string4;
        this._bits = byArray;
        this._homeJRE = JREInfo.getHomeJRE();
        this._matchImpl = matchJREIf;
        this._signed = false;
        if (this._resources != null) {
            this._resources.setParent(this);
            if (this.isApplication() || this.isApplet() || this.isInstaller()) {
                this.selectJRE();
                JARDesc jARDesc = this._resources.getMainJar(true);
                if (jARDesc != null) {
                    jARDesc.setLazyDownload(false);
                }
            }
        }
    }

    public JREInfo getHomeJRE() {
        return this._homeJRE;
    }

    public LaunchSelection.MatchJREIf getJREMatcher() {
        if (!this._matchImpl.hasBeenRun()) {
            this.selectJRE();
        }
        return this._matchImpl;
    }

    public JREInfo selectJRE() {
        this._selectedJRE = LaunchSelection.selectJRE(this, this._matchImpl);
        return this._selectedJRE;
    }

    public JREInfo selectJRE(LaunchSelection.MatchJREIf matchJREIf) {
        this._matchImpl = matchJREIf;
        return this.selectJRE();
    }

    public String getSpecVersion() {
        return this._specVersion;
    }

    public synchronized URL getCodebase() {
        return this._codebase;
    }

    public byte[] getBytes() {
        return this._bits;
    }

    public synchronized URL getLocation() {
        return this._home;
    }

    public synchronized URL getCanonicalHome() {
        if (this._home == null && this._resources != null) {
            JARDesc jARDesc = this._resources.getMainJar(true);
            URL uRL = null;
            try {
                if (jARDesc != null) {
                    uRL = new URL(jARDesc.getLocation().toString() + "jnlp");
                } else {
                    ExtensionDesc[] extensionDescArray = this._resources.getExtensionDescs();
                    if (extensionDescArray.length > 0) {
                        uRL = new URL(extensionDescArray[0].getLocation().toString() + ".jarjnlp");
                    }
                }
            }
            catch (MalformedURLException malformedURLException) {
                Trace.ignoredException((Exception)malformedURLException);
            }
            return uRL != null ? uRL : null;
        }
        return this._home;
    }

    public synchronized URL getSplashCanonicalHome() {
        if (this._home == null && this._resources != null) {
            JARDesc jARDesc = this._resources.getMainJar(true);
            return jARDesc != null ? jARDesc.getLocation() : null;
        }
        return this._home;
    }

    public InformationDesc getInformation() {
        return this._information;
    }

    public String getInternalCommand() {
        return this._internalCommand;
    }

    public int getSecurityModel() {
        return this._securiyModel;
    }

    public UpdateDesc getUpdate() {
        return this._update;
    }

    public boolean isSigned() {
        return this._signed;
    }

    public boolean isSecure() {
        return 0 == this.getSecurityModel();
    }

    public boolean isSecureJVMArgs() {
        return this.getJREMatcher().getSelectedJVMParameters().isSecure();
    }

    public ResourcesDesc getResources() {
        return this._resources;
    }

    public boolean arePropsSet() {
        return this._propsSet;
    }

    public void setPropsSet(boolean bl) {
        this._propsSet = bl;
    }

    public JREInfo getSelectedJRE() {
        return this._selectedJRE;
    }

    public int getLaunchType() {
        return this._launchType;
    }

    public ApplicationDesc getApplicationDescriptor() {
        return this._applicationDesc;
    }

    public AppletDesc getAppletDescriptor() {
        return this._appletDesc;
    }

    public InstallerDesc getInstallerDescriptor() {
        return this._installerDesc;
    }

    public boolean isApplication() {
        return this._launchType == 1;
    }

    public boolean isApplet() {
        return this._launchType == 2;
    }

    public boolean isLibrary() {
        return this._launchType == 3;
    }

    public boolean isInstaller() {
        return this._launchType == 4;
    }

    public boolean isApplicationDescriptor() {
        return this.isApplication() || this.isApplet();
    }

    public boolean isHttps() {
        if (this._codebase != null) {
            return this._codebase.getProtocol().equals("https");
        }
        this.getCanonicalHome();
        if (this._home != null) {
            return this._home.getProtocol().equals("https");
        }
        return false;
    }

    public String getSource() {
        return this._source;
    }

    public void checkSigning(LaunchDesc launchDesc) throws JNLPSigningException {
        if (!launchDesc.getSource().equals(this.getSource())) {
            throw new JNLPSigningException(this, launchDesc.getSource());
        }
        this._signed = true;
    }

    public boolean isJRESpecified() {
        final boolean[] blArray = new boolean[1];
        final boolean[] blArray2 = new boolean[1];
        if (this.getResources() != null) {
            this.getResources().visit(new ResourceVisitor(){

                public void visitJARDesc(JARDesc jARDesc) {
                    blArray2[0] = true;
                }

                public void visitPropertyDesc(PropertyDesc propertyDesc) {
                }

                public void visitPackageDesc(PackageDesc packageDesc) {
                }

                public void visitExtensionDesc(ExtensionDesc extensionDesc) {
                    blArray2[0] = true;
                }

                public void visitJREDesc(JREDesc jREDesc) {
                    blArray[0] = true;
                }
            });
        }
        if (this._launchType == 1 || this._launchType == 2) {
            blArray2[0] = true;
        }
        return blArray[0] || !blArray2[0];
    }

    public AppInfo getAppInfo() {
        AppInfo appInfo = new AppInfo(this.getLaunchType(), this._information.getTitle(), this._information.getVendor(), this.getCanonicalHome(), null, null, false, false, null, null);
        IconDesc iconDesc = this._information.getIconLocation(2, 0);
        if (iconDesc != null) {
            appInfo.setIconRef(iconDesc.getLocation());
            appInfo.setIconVersion(iconDesc.getVersion());
        }
        return appInfo;
    }

    public synchronized LDUpdater getUpdater() {
        if (this._updater == null) {
            this._updater = new LDUpdater(this);
        }
        return this._updater;
    }

    public XMLNode asXML() {
        XMLAttributeBuilder xMLAttributeBuilder = new XMLAttributeBuilder();
        xMLAttributeBuilder.add("spec", this._specVersion);
        xMLAttributeBuilder.add("codebase", this._codebase);
        xMLAttributeBuilder.add("version", this._version);
        xMLAttributeBuilder.add("href", this._home);
        XMLNodeBuilder xMLNodeBuilder = new XMLNodeBuilder("jnlp", xMLAttributeBuilder.getAttributeList());
        xMLNodeBuilder.add((XMLable)this._information);
        if (this._securiyModel == 1) {
            xMLNodeBuilder.add(new XMLNode("security", null, new XMLNode("all-permissions", null), null));
        } else if (this._securiyModel == 2) {
            xMLNodeBuilder.add(new XMLNode("security", null, new XMLNode("j2ee-application-client-permissions", null), null));
        }
        xMLNodeBuilder.add((XMLable)this._update);
        xMLNodeBuilder.add((XMLable)this._resources);
        xMLNodeBuilder.add((XMLable)this._applicationDesc);
        xMLNodeBuilder.add((XMLable)this._appletDesc);
        xMLNodeBuilder.add((XMLable)this._libraryDesc);
        xMLNodeBuilder.add((XMLable)this._installerDesc);
        return xMLNodeBuilder.getNode();
    }

    public String toString() {
        return this.asXML().toString();
    }
}

