<?php

	/***************************************************************\
	|																|
	|	房哨（多中介管理运营平台系统）									|
	|																|
	|	© 2019 http://fs.ytsofts.cn/ All rights reserved.			|
	|																|
	|	本系统由淮南市银泰软件科技有限公司提供技术支持					|
	|																|
	|	QQ号：984784483												|
	|																|
	\***************************************************************/

	namespace Erpadmin\Controller;
	use Think\Controller;
	use Common\Controller\BaseController;
	class ErpadminbaseController extends BaseController {

		public function _initialize(){
			parent::_initialize();
			if (!isset($_SESSION['erp_user'])) {
				$this->redirect('Login/index');
			}
			$this->userinfo = session('erp_user');
		}

		public function getThisWeekOf($date){
			$dates = array();
			$time = strtotime($date.' 12:00:00');
			$w = date('w', $time);
			if($w == 0){
				$nextMonday = 1;
			} else {
				$nextMonday = 7 - $w + 1;
			}
			for($i = $nextMonday; $i<$nextMonday + 7; $i++){
				$dates[] = date('Y-m-d', $time + 3600*24*$i - 3600*24*7);
			}
			return $dates;
		}

		public function getNextWeekOf($date){
			$dates = array();
			$time = strtotime($date.' 12:00:00');
			$w = date('w', $time);
			if($w == 0){
				$nextMonday = 1;
			} else {
				$nextMonday = 7 - $w + 1;
			}
			for($i = $nextMonday; $i<$nextMonday + 7; $i++){
				$dates[] = date('Y-m-d', $time + 3600*24*$i);
			}
			return $dates;
		}

	}