<?php

namespace app\home\controller;


use think\Lang;

class Pointshop extends BasePointShop
{
    public function _initialize()
    {
        parent::_initialize(); // TODO: Change the autogenerated stub
        Lang::load(APP_PATH.'home/lang/'.config('default_lang').'/pointprod.lang.php');
        Lang::load(APP_PATH.'home/lang/'.config('default_lang').'/voucher.lang.php');
    }
    public function index(){
        //查询会员及其附属信息
        parent::pointshopMInfo();

        //开启代金券功能后查询推荐的热门代金券列表
        if (config('voucher_allow') == 1){
            $recommend_voucher = model('voucher')->getRecommendTemplate(6);
            $this->assign('recommend_voucher',$recommend_voucher);
        }
        //开启积分兑换功能后查询推荐的热门兑换商品列表
        if (config('pointprod_isuse') == 1){
            //热门积分兑换商品
            $recommend_pointsprod = model('pointprod')->getRecommendPointProd(10);
            $this->assign('recommend_pointsprod',$recommend_pointsprod);
        }

        //SEO
        $this->_assign_seo(model('seo')->type('point')->show());
        //分类导航
        $nav_link = array(
            0=>array('title'=>lang('ds_index'),'link'=>HOME_SITE_URL),
            1=>array('title'=>lang('ds_pointprod'))
        );
        $this->assign('nav_link_list', $nav_link);
        return $this->fetch($this->template_dir.'pointprod');
    }

}