<?php

namespace app\home\controller;


use think\Lang;

class Memberconsult extends BaseMember
{
    public function _initialize()
    {
        parent::_initialize(); // TODO: Change the autogenerated stub
        Lang::load(APP_PATH . 'home/lang/'.config('default_lang').'/memberconsult.lang.php');
    }

    /**
     * 查询买家商品咨询
     */
    public function index()
    {
        $this->my_consult();
    }
    
    public function my_consult()
    {
        //实例化商品咨询模型
        $consult_model = model('consult');
        $search_array = array();
        if (input('param.type') != '') {
            if (input('param.type') == 'to_reply') {
                $search_array['consult_reply'] = '';
            }
            if (input('param.type') == 'replied') {
                $search_array['consult_reply'] = array(
                    'neq',
                    ''
                );
            }
        }
        $search_array['member_id'] = session('member_id');
        $list_consult = $consult_model->getConsultList($search_array);
        $this->assign('show_page', $consult_model->page_info->render());
        $this->assign('list_consult', $list_consult);
        $type_v=input('param.type');
        $type = empty($type_v) ? 'consult_list' : $type_v;
        /* 设置买家当前菜单 */
        $this->setMemberCurMenu('member_consult');
        /* 设置买家当前栏目 */
        $this->setMemberCurItem($type);
        echo $this->fetch($this->template_dir.'index');exit;
    }

    /**
     * 用户中心右边，小导航
     *
     * @param string $menu_type 导航类型
     * @param string $menu_key 当前导航的menu_key
     * @param array $array 附加菜单
     * @return
     */
    public function getMemberItemList()
    {
                $menu_array = array(
                     array(
                        'name' => 'consult_list',
                        'text' => lang('ds_member_path_all_consult'),
                        'url' => url('Memberconsult/index')
                    ),
                     array(
                        'name' => 'to_reply',
                        'text' => lang('ds_member_path_unreplied_consult'),
                        'url' => url('Memberconsult/index','type=to_reply')
                    ),
                     array(
                        'name' => 'replied',
                        'text' => lang('ds_member_path_replied_consult'),
                        'url' => url('Memberconsult/index','type=replied')
                    )
                );

       return $menu_array;
    }
}