<?php

namespace app\home\controller;


use think\Lang;

class Selleractivity extends BaseSeller
{
    public function _initialize()
    {
        parent::_initialize(); // TODO: Change the autogenerated stub
        Lang::load(APP_PATH . 'home/lang/'.config('default_lang').'/selleractivity.lang.php');
    }

    /**
     * 活动管理
     */
    public function index()
    {
        $activity_model = model('activity');
        //活动为商品活动，并且为开启状态
        $condition = array();
        $condition['activity_type'] = 1;
        $condition['activity_startdate'] = array('elt',TIMESTAMP);
        $condition['activity_enddate'] = array('egt',TIMESTAMP);
        $condition['activity_state'] = 1;
        
        $activity_list = $activity_model->getActivityList($condition, 10 , 'activity_sort asc');
        /**
         * 页面输出
         */
        //halt($list);
        $this->assign('activity_list', $activity_list);
        $this->assign('show_page', $activity_model->page_info->render());
        $this->setSellerCurMenu('Selleractivity');
        $this->setSellerCurItem('index');
        return $this->fetch($this->template_dir.'index');
    }

    /**
     * 参与活动
     */
    public function activity_apply()
    {
        //根据活动编号查询活动信息
        $activity_id = intval(input('param.activity_id'));
        if ($activity_id <= 0) {
            $this->error(lang('param_error'), 'Selleractivity/index');
        }
        $activity_model = model('activity');
        $activity_info = $activity_model->getOneActivityById($activity_id);
        //活动类型必须是商品并且活动没有关闭并且活动进行中
        if (empty($activity_info) || $activity_info['activity_type'] != '1' || $activity_info['activity_state'] != 1 || $activity_info['activity_startdate'] > time() || $activity_info['activity_enddate'] < time()) {
            $this->error(lang('store_activity_not_exists'), 'Selleractivity/index');
        }
        $this->assign('activity_info', $activity_info);
        $activitydetail_list = array();//声明存放活动细节的数组
        //查询商品分类列表
       /* $gc = model('goodsclass');
        $gc_list = $gc->getTreeClassList(3);
        foreach ($gc_list as $k => $gc) {
            $gc_list[$k]['gc_name'] = '';
            $gc_list[$k]['gc_name'] = str_repeat("&nbsp;", $gc['deep'] * 2) . $gc['gc_name'];
        }
        $this->assign('gc_list', $gc_list);
        //halt($gc_list);*/
        //查询品牌列表
        $brand = model('brand');
        $brand_list = $brand->getBrandList(array());
        $this->assign('brand_list', $brand_list);
        //查询活动细节信息
        $activitydetail_model = model('activitydetail');
        
        $condition = array();
        $condition['activitydetail.activity_id'] = $activity_id;
        $condition['activitydetail.store_id'] = session('store_id');
        $condition['activitydetail.activitydetail_state'] = array('in',array('0','1','3'));
        $activitydetail_list = $activitydetail_model->getGoodsJoinList($condition);
        //构造通过与审核中商品的编号数组,以便在下方待选列表中,不显示这些内容
        $item_ids = array();
        if (is_array($activitydetail_list) and !empty($activitydetail_list)) {
            foreach ($activitydetail_list as $k => $v) {
                $item_ids[] = $v['item_id'];
            }
        }

        $this->assign('activitydetail_list', $activitydetail_list);

        //根据查询条件查询商品列表
        $condition = array();
        if (input('param.gc_id') != '') {
            $condition['gc_id'] = intval(input('param.gc_id'));
        }
        if (input('param.brand_id') != '') {
            $condition['brand_id'] = intval(input('param.brand_id'));
        }
        if (trim(input('param.name')) != '') {
            $condition['goods_name'] = array('like', '%' . trim(input('param.name')) . '%');
        }
        $condition['store_id'] = session('store_id');
        if (!empty($item_ids)) {
            $condition['goods_id'] = array('not in', $item_ids);
        }
        $goods_model = model('goods');
        $goods_list = $goods_model->getGoodsOnlineList($condition, '*', 10);
        $this->assign('goods_list', $goods_list);
        $this->assign('show_page', $goods_model->page_info->render());
        $this->assign('search', input('param.get'));
        /**
         * 页面输出
         */
        $this->setSellerCurMenu('Selleractivity');
        $this->setSellerCurItem('activity_apply');
        return $this->fetch($this->template_dir.'activity_apply');
    }

    /**
     * 活动申请保存
     */
    public function activity_apply_save()
    {
        //判断页面参数
        $item_id_array = input('post.item_id/a');#获取POST数组
        if (empty($item_id_array)) {
            ds_json_encode(10001,lang('store_activity_choose_goods'));
        }
        $activity_id = intval(input('post.activity_id'));
        if ($activity_id <= 0) {
            ds_json_encode(10001,lang('param_error'));
        }
        //根据页面参数查询活动内容信息，如果不存在则添加，存在则根据状态进行修改
        $activity_model = model('activity');
        $activity = $activity_model->getOneActivityById($activity_id);
        //活动类型必须是商品并且活动没有关闭并且活动进行中
        if (empty($activity) || $activity['activity_type'] != '1' || $activity['activity_state'] != '1' || $activity['activity_startdate'] > time() || $activity['activity_enddate'] < time()) {
            ds_json_encode(10001,lang('store_activity_not_exists'));
        }
        $activitydetail_model = model('activitydetail');
        $list = $activitydetail_model->getActivitydetailList(array('store_id' => session('store_id'), 'activity_id' => "$activity_id"));
        $ids = array();//已经存在的活动内容编号
        $ids_state2 = array();//已经存在的被拒绝的活动编号
        if (is_array($list) and !empty($list)) {
            foreach ($list as $ad) {
                $ids[] = $ad['item_id'];
                if ($ad['activitydetail_state'] == '2') {
                    $ids_state2[] = $ad['item_id'];
                }
            }
        }
        //根据查询条件查询商品列表
        foreach ($item_id_array as $item_id) {
            $item_id = intval($item_id);
            if (!in_array($item_id, $ids)) {
                $input = array();
                $input['activity_id'] = $activity_id;
                $goods = model('goods');
                $item = $goods->getGoodsOnlineInfoByID($item_id);
                if (empty($item) || $item['store_id'] != session('store_id')) {
                    continue;
                }
                $input['item_name'] = $item['goods_name'];
                $input['item_id'] = $item_id;
                $input['store_id'] = $item['store_id'];
                $input['store_name'] = $item['store_name'];
                $activitydetail_model->addActivitydetail($input);
            }
            elseif (in_array($item_id, $ids_state2)) {
                $input = array();
                $input['activitydetail_state'] = '0';//将重新审核状态去除
                $activitydetail_model->editActivitydetail($input, array('item_id' => $item_id));
            }
        }
        ds_json_encode(10000,lang('store_activity_submitted'));
    }

    /**
     * 用户中心右边，小导航
     *
     * @param string $menu_type 导航类型
     * @param string $menu_key 当前导航的menu_key
     * @return
     */
    protected function getSellerItemList()
    {
        $menu_array = array(
            array(
                'name' => 'index', 'text' => lang('ds_member_path_activity_list'),
                'url' => url('Selleractivity/index')
            )
        );
        if (request()->action() == 'activity_apply') {
            $menu_array[]=
            array(
                'name' => 'activity_apply', 'text' => lang('ds_member_path_join_activity'),
                'url' => ''
            );
        }
        return $menu_array;
    }
}