<?php

namespace app\home\controller;


use think\Lang;

class Memberpointorder extends BaseMember
{
    public function _initialize()
    {
        parent::_initialize(); // TODO: Change the autogenerated stub
        Lang::load(APP_PATH . 'home/lang/'.config('default_lang').'/memberpoints.lang.php');
    }


    public function index()
    {
        $this->orderlist();
    }
    
    /**
     * 兑换信息列表
     */
    function orderlist()
    {
        //兑换信息列表
        $where = array();
        $where['point_buyerid'] = session('member_id');

        $pointorder_model = model('pointorder');
        $order_list = $pointorder_model->getPointorderList($where, '*', 10, 0, 'point_orderid desc');
        $order_idarr = array();
        $order_listnew = array();
        if (is_array($order_list) && count($order_list) > 0) {
            foreach ($order_list as $k => $v) {
                $order_listnew[$v['point_orderid']] = $v;
                $order_idarr[] = $v['point_orderid'];
            }
        }

        //查询兑换商品
        if (is_array($order_idarr) && count($order_idarr) > 0) {
            $prod_list = $pointorder_model->getPointordergoodsList(array('pointog_orderid' => array('in',$order_idarr)));
            if (is_array($prod_list) && count($prod_list) > 0) {
                foreach ($prod_list as $v) {
                    if (isset($order_listnew[$v['pointog_orderid']])) {
                        $order_listnew[$v['pointog_orderid']]['prodlist'][] = $v;
                    }
                }
            }
        }

        //信息输出
        $this->assign('order_list', $order_listnew);
        $this->assign('show_page', $pointorder_model->page_info->render());
        /* 设置买家当前菜单 */
        $this->setMemberCurMenu('member_point');
        /* 设置买家当前栏目 */
        $this->setMemberCurItem('orderlist');
        echo $this->fetch($this->template_dir.'index');exit;
    }

    /**
     *    取消兑换
     */
    public function cancel_order()
    {
        $pointorder_model = model('pointorder');
        //取消订单
        $data = $pointorder_model->cancelPointorder(input('param.order_id'), session('member_id'));
        if ($data['state']) {
            ds_json_encode(10000,lang('member_pointorder_cancel_success'));
        } else {
            ds_json_encode(10001,$data['msg']);
        }
    }

    /**
     * 确认收货
     */
    public function receiving_order()
    {
        $data = model('pointorder')->receivingPointorder(input('param.order_id'));
        if ($data['state']) {
            ds_json_encode(10000,lang('member_pointorder_confirmreceiving_success'));
        } else {
            ds_json_encode(10001,$data['msg']);
        }
    }

    /**
     * 兑换信息详细
     */
    public function order_info()
    {
        $order_id = intval(input('order_id'));
        if ($order_id <= 0) {
            $this->error(lang('member_pointorder_parameter_error'));
        }
        $pointorder_model = model('pointorder');
        //查询兑换订单信息
        $where = array();
        $where['point_orderid'] = $order_id;
        $where['point_buyerid'] = session('member_id');
        $order_info = $pointorder_model->getPointorderInfo($where);
        if (!$order_info) {
            $this->error(lang('member_pointorder_record_error'));
        }
        //获取订单状态
        $pointorderstate_arr = $pointorder_model->getPointorderStateBySign();
        $this->assign('pointorderstate_arr', $pointorderstate_arr);

        //查询兑换订单收货人地址
        $orderaddress_info = $pointorder_model->getPointorderAddressInfo(array('pointoa_orderid' => $order_id));
        $this->assign('orderaddress_info', $orderaddress_info);

        //兑换商品信息
        $prod_list = $pointorder_model->getPointordergoodsList(array('pointog_orderid' => $order_id));
        $this->assign('prod_list', $prod_list);

        //物流公司信息
        if ($order_info['point_shipping_ecode'] != '') {
            $data = model('express')->getExpressInfoByECode($order_info['point_shipping_ecode']);
            if ($data['state']) {
                $express_info = $data['data']['express_info'];
            }
            $this->assign('express_info', $express_info);
        }

        $this->assign('order_info', $order_info);
        $this->assign('left_show', 'order_view');
        
        
        /* 设置买家当前菜单 */
        $this->setMemberCurMenu('member_point');
        /* 设置买家当前栏目 */
        $this->setMemberCurItem('order_info');
        return $this->fetch($this->template_dir.'member_pointorder_info');
    }

    /**
     * 用户中心右边，小导航
     *
     * @param string $menu_type 导航类型
     * @param string $menu_key 当前导航的menu_key
     * @return
     */
    public function getMemberItemList()
    {
       
        $menu_array = array();
        if(request()->action()=='index'||request()->action()=='orderlist'){
                $menu_array = array(
                   array(
                        'name' => 'points',
                        'text' => lang('ds_member_path_points'),
                        'url' => url('Memberpoints/index')
                    ),
                    array(
                        'name' => 'orderlist',
                        'text' => lang('member_pointorder_list_title'),
                        'url' => url('Memberpointorder/orderlist')
                    )
                );
        }
        if(request()->action()=='orderlistin'){
                $menu_array = array(
                    array(
                        'name' => 'points',
                        'text' => lang('ds_member_path_points'),
                        'url' => url('Memberpoints/index')
                    ),
                     array(
                        'name' => 'orderlist',
                        'text' => lang('ds_member_path_pointorder_list'),
                        'url' => url('Memberpointorder/orderlist')
                    ),
                     array(
                        'name' => 'orderinfo',
                        'text' => lang('ds_member_path_pointorder_info'),
                        ''
                    )
                );
        }
       return $menu_array;
    }
}