<?php
namespace app\home\controller;
use think\Lang;
class Membermallconsult extends BaseMember {

    public function _initialize() {
        parent::_initialize(); // TODO: Change the autogenerated stub
        Lang::load(APP_PATH . 'home/lang/'.config('default_lang').'/membermallconsult.lang.php');
    }

    /**
     * 平台客服咨询首页
     */
    public function index() {
        // 咨询列表
        $mallconsult_model = model('mallconsult');
        $consult_list = $mallconsult_model->getMallconsultList(array('member_id' => session('member_id')), '*', '10');
        $this->assign('consult_list', $consult_list);
        $this->assign('show_page', $mallconsult_model->page_info->render());

        // 回复状态
        $this->typeState();
        $this->setMemberCurMenu('member_mallconsult');
        $this->setMemberCurItem('consult_list');
        return $this->fetch($this->template_dir . 'member_mallconsult_list');
    }

    /**
     * 平台咨询详细
     */
    public function mallconsult_info() {
        $id = intval(input('param.id'));
        if ($id <= 0) {
            $this->error(lang('wrong_argument'));
        }
        // 咨询详细信息
        $consult_info = model('mallconsult')->getMallconsultInfo(array(
            'mallconsult_id' => $id, 'member_id' => session('member_id')
        ));
        $this->assign('consult_info', $consult_info);

        // 咨询类型列表
        $type_list = model('mallconsulttype')->getMallconsulttypeList(array(), 'mallconsulttype_id,mallconsulttype_name', 'mallconsulttype_id');
        $this->assign('type_list', $type_list);

        // 回复状态
        $this->typeState();

        $this->setMemberCurMenu('member_mallconsult');
        $this->setMemberCurItem('consult_list');
        return $this->fetch($this->template_dir . 'member_mallconsult_info');
    }

    /**
     * 添加平台客服咨询
     */
    public function add_mallconsult() {
        // 咨询类型列表
        $type_list = model('mallconsulttype')->getMallconsulttypeList(array());
        $this->assign('type_list', $type_list);
        if (input('param.inajax')) {
            return $this->fetch($this->template_dir . 'add_inajax');
        } else {
            $this->setMemberCurMenu('member_mallconsult');
            $this->setMemberCurItem('consult_list');
            return $this->fetch($this->template_dir . 'member_mallconsult_add');
        }
    }

    /**
     * 保存平台咨询
     */
    public function save_mallconsult() {
        if (!request()->isPost()) {
            ds_json_encode(10001,lang('wrong_argument'));
        }

        //验证表单信息
        $data = [
            'type_id' => input('post.type_id'),
            'consult_content' => input('post.consult_content')
        ];

        $mallconsult_validate = validate('mallconsult');
        if (!$mallconsult_validate->scene('save_mallconsult')->check($data)) {
            ds_json_encode(10001,$mallconsult_validate->getError());
        }

        $insert = array();
        $insert['mallconsulttype_id'] = input('post.type_id');
        $insert['member_id'] = session('member_id');
        $insert['member_name'] = session('member_name');
        $insert['mallconsult_content'] = input('post.consult_content');

        $result = model('mallconsult')->addMallconsult($insert);
        if ($result) {
            ds_json_encode(10000,lang('ds_common_op_succ'));
        } else {
            ds_json_encode(10001,lang('ds_common_op_fail'));
        }
    }

    /**
     * 删除平台客服咨询
     */
    public function del_mallconsult() {
        $id = intval(input('param.id'));
        if ($id <= 0) {
            ds_json_encode(10001,lang('wrong_argument'));
        }

        $result = model('mallconsult')->delMallconsult(array('mallconsult_id' => $id, 'member_id' => session('member_id')));
        if ($result) {
            ds_json_encode(10000,lang('ds_common_del_succ'));
        } else {
            ds_json_encode(10001,lang('ds_common_del_fail'));
        }
    }

    /**
     * 咨询的回复状态
     */
    private function typeState() {
        $state = array('0' => lang('did_not_return'), '1' => lang('have_to_reply'));
        $this->assign('state', $state);
    }

    /**
     * 用户中心右边，小导航
     *
     * @param string $menu_key 当前导航的menu_key
     * @return
     */
    protected function getMemberItemList() {
        $menu_array = array(
            array(
                'name' => 'consult_list', 'text' => lang('platform_customer_service_consultation_list'),
                'url' => url('Membermallconsult/index')
            ),
        );
        return $menu_array;
    }

}