<?php

namespace app\home\controller;

use think\Lang;

class Flea extends BaseFlea {

    public function _initialize() {
        parent::_initialize(); // TODO: Change the autogenerated stub
        Lang::load(APP_PATH . 'home/lang/'.config('default_lang').'/flea.lang.php');
        Lang::load(APP_PATH . 'home/lang/'.config('default_lang').'/fleacommon.lang.php');
    }

    /**
     * 闲置市场首页
     */
    public function index() {

        /**
         * 地区
         */
        $fleaarea_model = model('fleaarea');
        $area_array = $fleaarea_model->fleaarea_show();
        $this->assign('area_one_level', $area_array['area_one_level']);
        $this->assign('area_two_level', $area_array['area_two_level']);
        /**
         * 分类
         */
        
        $fleaclass_model = model('fleaclass');
        $goods_class = $fleaclass_model->getTreeClassList(3, array('fleaclass_show' => 1));
        if (is_array($goods_class) and !empty($goods_class)) {
            $show_goods_class = array();
            $arr = array();
            foreach ($goods_class as $val) {
                if ($val['fleaclass_parent_id'] == 0) {
                    $show_goods_class[$val['fleaclass_id']]['class_name'] = $val['fleaclass_name'];
                    $show_goods_class[$val['fleaclass_id']]['class_id'] = $val['fleaclass_id'];
                    $show_goods_class[$val['fleaclass_id']]['fleaclass_index_show'] = $val['fleaclass_index_show'];

                    $arr[$val['fleaclass_id']]['class_name'] = $val['fleaclass_name'];
                    $arr[$val['fleaclass_id']]['class_id'] = $val['fleaclass_id'];
                    if (!isset($arr[$val['fleaclass_id']]['fleaclass_id_str'])) {
                        $arr[$val['fleaclass_id']]['fleaclass_id_str'] = '';
                    }
                    $arr[$val['fleaclass_id']]['fleaclass_id_str'] .= ',' . $val['fleaclass_id'];
                } else {
                    if (isset($show_goods_class[$val['fleaclass_parent_id']])) {
                        $show_goods_class[$val['fleaclass_parent_id']]['sub_class'][$val['fleaclass_id']]['class_name'] = $val['fleaclass_name'];
                        $show_goods_class[$val['fleaclass_parent_id']]['sub_class'][$val['fleaclass_id']]['class_id'] = $val['fleaclass_id'];
                        $show_goods_class[$val['fleaclass_parent_id']]['sub_class'][$val['fleaclass_id']]['fleaclass_parent_id'] = $val['fleaclass_parent_id'];
                        $show_goods_class[$val['fleaclass_parent_id']]['sub_class'][$val['fleaclass_id']]['fleaclass_index_show'] = $val['fleaclass_index_show'];

                        $arr[$val['fleaclass_parent_id']]['sub_class'][$val['fleaclass_id']]['class_name'] = $val['fleaclass_name'];
                        $arr[$val['fleaclass_parent_id']]['sub_class'][$val['fleaclass_id']]['class_id'] = $val['fleaclass_id'];
                        $arr[$val['fleaclass_parent_id']]['fleaclass_id_str'] .= ',' . $val['fleaclass_id'];
                    } else {
                        foreach ($show_goods_class as $v) {
                            if (isset($v['sub_class'][$val['fleaclass_parent_id']])) {
                                $show_goods_class[$v['sub_class'][$val['fleaclass_parent_id']]['fleaclass_parent_id']]['sub_class'][$val['fleaclass_parent_id']]['sub_class'][$val['fleaclass_id']]['class_name'] = $val['fleaclass_name'];
                                $show_goods_class[$v['sub_class'][$val['fleaclass_parent_id']]['fleaclass_parent_id']]['sub_class'][$val['fleaclass_parent_id']]['sub_class'][$val['fleaclass_id']]['class_id'] = $val['fleaclass_id'];

                                $arr[$v['sub_class'][$val['fleaclass_parent_id']]['fleaclass_parent_id']]['fleaclass_id_str'] .= ',' . $v['fleaclass_id'];
                            }
                        }
                    }
                }
            }
        }

        $new_arr = array();
        $flea_model = model('flea');
        $condition = array();
        $condition['flea.goods_image'] = array('neq','');
        if (isset($arr) && !empty($arr)) {
            foreach ($arr as $key => $value) {
                if (isset($new_arr[4]) && is_array($new_arr[4]) && !empty($new_arr[4]))
                    break; //只取前5条分类下有的商品
                $condition['flea.fleaclass_id'] = array('in',$value['fleaclass_id_str']);
                $arr[$key]['goods'] = $flea_model->getFleaByClass($condition,'goods_id,goods_name,goods_store_price,flea_quality,member_id,goods_image','goods_id desc',14);
                if (is_array($arr[$key]['goods']) && !empty($arr[$key]['goods']))
                    $new_arr[] = $arr[$key];
            }
        }
        $this->assign('show_flea_goods_class_list', $new_arr);
        /**
         * js滑动参数
         */
        $str = '';
        $str1 = '';
        for ($j = 1; $j <= count($new_arr); $j++) {
            $str .= '"m0' . $j . '"' . ',';
            $str1 .= '"c0' . $j . '"' . ',';
        }
        $str = rtrim($str, ",");
        $str1 = rtrim($str1, ",");
        $this->assign('mstr', $str);
        $this->assign('cstr', $str1);
        /**
         * 新鲜货
         */
        $condition = array();
        $condition['goods_image'] = array('neq','');
        $condition['goods_body'] = array('neq','');
        $new_flea_goods = $flea_model->getOneFlea($condition);
        $this->assign('new_flea_goods', $new_flea_goods);
        /**
         * 收藏第一
         */
        $condition = array();
        $condition['goods_image'] = array('neq','');
        $col_flea_goods = $flea_model->getOneFlea($condition);
        $this->assign('col_flea_goods', $col_flea_goods);
        /**
         * 标题过滤
         */
        $tstr = $new_flea_goods['goods_body'];
        $zz = array(
            '/(<p(.*?)>|<\/p>)/i',
            '/(<span(.*?)>|<\/p>)/i',
            '/(<img(.*?)>|<\/p>)/i',
            '/(<h1(.*?)>|<\/p>)/i',
            '/(<u(.*?)>|<\/p>)/i',
            '/(<strong(.*?)>|<\/p>)/i',
            '/\s*/'
        );
        $con = array(
            '',
            '',
            '',
            '',
            '',
            '',
            ''
        );
        $tstr = preg_replace($zz, $con, $tstr);
        $this->assign('one_goods_title', $tstr);
        /**
         * 热门搜
         */
        $new_flea_goods2 = $flea_model->getFleaList(array('limit' => '0,14', 'order' => 'goods_click desc', 'pic_input' => '2'));
        $this->assign('new_flea_goods2', $new_flea_goods2);
        /**
         * 闲置围观区
         */
        $new_flea_goods3 = $flea_model->getFleaList(array('limit' => '0,14', 'order' => 'goods_id desc', 'pic_input' => '2'));
        $this->assign('new_flea_goods3', $new_flea_goods3);
        /**
         * 导航标识
         */
        $this->assign('index_sign', 'flea');
        // 首页幻灯
        $loginpic = unserialize(config('flea_loginpic'));
        $this->assign('loginpic', $loginpic);
        
        /**
         * 获取设置信息
         */
        $fleaclass_model = model('fleaclass');
        $fc_index = $fleaclass_model->getFleaclassindex(array());
        if (!empty($fc_index) && is_array($fc_index)) {
            foreach ($fc_index as $value) {
                $this->assign($value['fcindex_code'], $value);
            }
        }
        //SEO 设置
        $seo = array(
            'html_title'=>config('flea_site_title'),
            'seo_keywords'=>config('flea_site_keywords'),
            'seo_description'=>config('flea_site_description'),
            
        );
        $this->_assign_seo($seo);
        
        return $this->fetch($this->template_dir . 'flea_index');
    }

}
