<?php

namespace app\admin\controller;


class Storejoin extends AdminControl
{
    public function _initialize()
    {
        parent::_initialize(); // TODO: Change the autogenerated stub
    }

    /**
     * 前台头部图片传
     */
    public function index() {
        $size = 3;//上传显示图片总数
        $i = 1;
        $info['pic'] = array();
        $info['show_txt'] = '';
        $config_model = model('config');
        $code_info = $config_model->getOneConfigByCode('store_joinin_pic');
        if(!empty($code_info['value'])) {
            $info = unserialize($code_info['value']);
        }
        
        $post = input('post.');#获取POST 数据
        
        if (request()->isPost()) {
            $info['show_txt'] = input('post.show_txt');
            for ($i;$i <= $size;$i++) {
                $file = 'pic'.$i;
                $info['pic'][$i] = $post['show_pic'.$i];
                if (!empty($_FILES[$file]['name'])) {//上传图片
                    $filename_tmparr = explode('.', $_FILES[$file]['name']);
                    $ext = end($filename_tmparr);
                    $file_name = 'store_joinin_'.$i.'.'.$ext;
                    $upload_file= BASE_UPLOAD_PATH . DS. 'admin/Storejion';
                    $file = request()->file($file);
                    $result = $file->validate(['ext'=>ALLOW_IMG_EXT])->move($upload_file,$file_name);
                    if ($result) {
                        $info['pic'][$i] = $file_name;
                    }
                }
            }
            $code_info = serialize($info);

            $update_array = array();
            $update_array['store_joinin_pic'] = $code_info;
             $config_model->editConfig($update_array);
            $this->success(lang('ds_common_save_succ'),'Storejoin/index');
        }
        $this->assign('size',$size);
        $this->assign('pic',$info['pic']);
        $this->assign('show_txt',$info['show_txt']);
        $this->setAdminCurItem('index');
        return $this->fetch();
    }

    /**
     * 入驻指南
     *
     */
    public function help_list() {
        $help_model = model('help');
        $condition = array();
        $condition['helptype_id'] = '1';
        $help_list = $help_model->getStoreHelpList($condition);
        $this->assign('help_list',$help_list);
        $this->setAdminCurItem('help_list');
        return $this->fetch();
    }

    /**
     * 编辑入驻指南
     *
     */
    public function edit_help() {
        $help_model = model('help');
        $condition = array();
        $help_id = intval(input('param.help_id'));
        $condition['help_id'] = $help_id;
        $help_list = $help_model->getStoreHelpList($condition);
        $help = $help_list[0];
        $help['help_info']= str_replace("\r\n","",$help['help_info']);
        $this->assign('help',$help);
        if (request()->isPost()) {
            $help_array = array();
            $help_array['help_title'] = input('post.help_title');
            $help_array['help_info'] = input('post.help_info');
            $help_array['help_sort'] = intval(input('post.help_sort'));
            $help_array['help_updatetime'] = time();
            $state = $help_model->editHelp($condition, $help_array);
            if ($state) {
                $this->log('编辑店铺入驻指南，编号'.$help_id);
                $this->success(lang('ds_common_save_succ'),'storejoin/help_list');
            } else {
                $this->error(lang('ds_common_save_fail'));
            }
        }
        $condition = array();
        $condition['item_id'] = $help_id;
        $pic_list = $help_model->getHelpPicList($condition);
        $this->assign('pic_list',$pic_list);
        $this->setAdminCurItem('edit');
        return $this->fetch();
    }

    /**
     * 上传图片
     */
    public function upload_pic() {
        $data = array();
        if (!empty($_FILES['fileupload']['name'])) {//上传图片
            $fprefix = 'admin/storehelp';
            $upload_file= BASE_UPLOAD_PATH . DS. $fprefix;
            $file = request()->file('fileupload');
            $info = $file->rule('uniqid')->validate(['ext'=>ALLOW_IMG_EXT])->move($upload_file);
            if($info){
                $file_name=$info->getFilename();
            }
            $upload_model = model('upload');
            $insert_array = array();
            $insert_array['file_name'] = $file_name;
            $insert_array['file_size'] = $_FILES['fileupload']['size'];
            $insert_array['upload_time'] = time();
            $insert_array['item_id'] = intval(input('param.item_id'));
            $insert_array['upload_type'] = '2';
            $result = $upload_model->addUpload($insert_array);
            if ($result) {
                $data['file_id'] = $result;
                $data['file_name'] = $file_name;
                $data['file_path'] = UPLOAD_SITE_URL.'/'.$fprefix.'/'.$file_name;
            }
        }
        echo json_encode($data);
        exit;
    }

    /**
     * 删除图片
     */
    public function del_pic() {
        $condition = array();
        $condition['upload_id'] = intval(input('param.file_id'));
        $help_model = model('help');
        $state = $help_model->delHelpPic($condition);
        if ($state) {
            echo 'true';exit;
        } else {
            echo 'false';exit;
        }
    }

    protected function getAdminItemList()
    {
        $menu_array = array(
            array(
                'name' => 'index', 'text' => '图片及提示', 'url' => url('Storejoin/index')
            ), array(
                'name' => 'help_list', 'text' => '入驻指南', 'url' => url('Storejoin/help_list')
            )
        );
        if (request()->action() == 'edit_help') {
            $menu_array[] = array('name' => 'edit', 'text' => '编辑内容', 'url' => 'javascript:void(0)');
        }
        return $menu_array;
    }
}