<?php

namespace app\admin\controller;


class Promotionbooth extends AdminControl {

    public function _initialize() {
        parent::_initialize(); // TODO: Change the autogenerated stub
    }

    public function index() {

        //自动开启优惠套装
        if (intval(input('param.promotion_allow')) === 1) {
            $config_model = model('config');
            $update_array = array();
            $update_array['promotion_allow'] = 1;
            $config_model->editConfig($update_array);
        }
        /**
         * 处理商品分类
         */
        $gcid = intval(input('param.choose_gcid'));
        $choose_gcid = $gcid > 0 ? $gcid : 0;
        $gccache_arr = model('goodsclass')->getGoodsclassCache($choose_gcid, 3);
        $this->assign('gc_json', json_encode($gccache_arr['showclass']));
        $this->assign('gc_choose_json', json_encode($gccache_arr['choose_gcid']));

        $pbooth_model = model('pbooth');
        $where = array();
        if (intval(input('param.choose_gcid')) > 0) {
            $where['gc_id'] = intval(input('param.choose_gcid'));
        }
        $goods_list = $pbooth_model->getBoothgoodsList($where, 'goods_id', 10);
        if (!empty($goods_list)) {
            $goodsid_array = array();
            foreach ($goods_list as $val) {
                $goodsid_array[] = $val['goods_id'];
            }
            $goods_list = model('goods')->getGoodsList(array('goods_id' => array('in', $goodsid_array)));
        }
        $this->assign('gc_list', model('goodsclass')->getGoodsclassForCacheModel());
        $this->assign('goods_list', $goods_list);
        $this->assign('show_page', $pbooth_model->page_info->render());

        $this->setAdminCurItem('index');
        // 输出自营店铺IDS
        $this->assign('flippedOwnShopIds', array_flip(model('store')->getOwnShopIds()));
        return $this->fetch();
    }

    /**
     * 套餐列表
     */
    public function booth_quota() {
        $pbooth_model = model('pbooth');
        $where = array();
        if (input('param.store_name') != '') {
            $where['store_name'] = array('like', '%' . trim(input('param.store_name')) . '%');
        }
        $booth_list = $pbooth_model->getBoothquotaList($where, '*', 10);

        // 状态数组
        $state_array = array(0 => lang('close'), 1 => lang('open'));
        $this->assign('state_array', $state_array);

        $this->setAdminCurItem('booth_quota');
        $this->assign('booth_list', $booth_list);
        $this->assign('show_page', $pbooth_model->page_info->render());
        return $this->fetch();
    }

    /**
     * 删除推荐商品
     */
    public function del_goods() {
        $where = array();
        $goods_id = input('param.goods_id');
        $goods_id_array = ds_delete_param($goods_id);
        if ($goods_id_array == FALSE) {
            ds_json_encode('10001', lang('param_error'));
        }
        $where['goods_id'] = array('in', $goods_id_array);
        $rs = model('pbooth')->delBoothgoods($where);
        if ($rs) {
            ds_json_encode(10000, lang('ds_common_del_succ'));
        } else {
            ds_json_encode(10001, lang('ds_common_del_fail'));
        }
    }

    /**
     * 设置
     */
    public function booth_setting() {
        // 实例化模型
        $config_model = model('config');

        if (request()->isPost()) {
            // 验证
            $data = [
                'promotion_booth_price' => input('post.promotion_booth_price'),
                'promotion_booth_goods_sum' => input('post.promotion_booth_goods_sum'),
            ];
            $promotionbooth_validate = validate('promotionbooth');
            if (!$promotionbooth_validate->scene('booth_setting')->check($data)){
                $this->error($promotionbooth_validate->getError());
            }

            $data['promotion_booth_price'] = intval(input('post.promotion_booth_price'));
            $data['promotion_booth_goods_sum'] = intval(input('post.promotion_booth_goods_sum'));

            $return = $config_model->editConfig($data);
            if ($return) {
                $this->log(lang('ds_set') . ' 推荐展位');
                dsLayerOpenSuccess(lang('ds_common_op_succ'));
            } else {
                $this->error(lang('ds_common_op_fail'));
            }
        } else {
            // 查询setting列表
            $setting = rkcache('config', true);
            $this->assign('setting', $setting);
            return $this->fetch();
        }
    }

    protected function getAdminItemList() {
        $menu_array = array(
            array(
                'name' => 'index',
                'text' => '商品列表',
                'url' => url('Promotionbooth/index')
            ), array(
                'name' => 'booth_quota',
                'text' => '套餐列表',
                'url' => url('Promotionbooth/booth_quota')
            ), array(
                'name' => 'booth_setting',
                'text' => '设置',
                'url' => "javascript:dsLayerOpen('" . url('Promotionbooth/booth_setting') . "','设置')"
            ),
        );
        return $menu_array;
    }

}
