<?php

namespace app\admin\controller;

use think\Lang;

class Consulting extends AdminControl {

    public function _initialize() {
        parent::_initialize(); // TODO: Change the autogenerated stub
        Lang::load(APP_PATH . 'admin/lang/'.config('default_lang').'/consulting.lang.php');
    }

    /**
     * 咨询管理
     */
    public function consulting() {
        $condition = array();
        $member_name = trim(input('param.member_name'));
        if ($member_name != '') {
            $condition['member_name'] = array('like', '%' . $member_name . '%');
            $this->assign('member_name', $member_name);
        }
        $consult_content = trim(input('param.consult_content'));
        if ($consult_content != '') {
            $condition['consult_content'] = array('like', '%' . $consult_content . '%');
            $this->assign('consult_content', $consult_content);
        }
        $ctid = intval(input('param.ctid'));
        if ($ctid > 0) {
            $condition['consulttype_id'] = $ctid;
            $this->assign('ctid', $ctid);
        }
        $consult_model = model('consult');
        $consult_list = $consult_model->getConsultList($condition, '*');
        
        $this->assign('filtered', $condition ? 1 : 0); //是否有查询条件
        
        $this->assign('show_page', $consult_model->page_info->render());
        $this->assign('consult_list', $consult_list);


        // 咨询类型
        $consult_type = rkcache('consulttype', true);
        $this->assign('consult_type', $consult_type);
        $this->setAdminCurItem('index');
        return $this->fetch();
    }

    public function delete() {
        $consult_id = input('param.consult_id');
        $consult_id_array = ds_delete_param($consult_id);
        if($consult_id_array === FALSE){
            $this->error(lang('param_error'));
        }
        $condition = array('consult_id' => array('in', $consult_id_array));
        $consult = model('consult');
        if ($consult->delConsult($condition)) {
            $this->log(lang('delete_consulting') . '[ID:' . $consult_id . ']', null);
            ds_json_encode('10000', lang('ds_common_del_succ'));
        } else {
            ds_json_encode('10001', lang('ds_common_del_fail'));
        }
    }


    /**
     * 咨询类型列表
     */
    public function type_list() {
        $consulttype_model = model('consulttype');
        $type_list = $consulttype_model->getConsulttypeList(array(), 'consulttype_id,consulttype_name,consulttype_sort');
        $this->assign('type_list', $type_list);
        $this->setAdminCurItem('type_list');
        return $this->fetch();
    }

    /**
     * 新增咨询类型
     */
    public function type_add() {
        if (request()->isPost()) {
            // 验证
            $data = [
                'consulttype_name' => input('post.consulttype_name'),
                'consulttype_sort' => input('post.consulttype_sort'),
            ];
            $consulting_validate = validate('consulting');
            if (!$consulting_validate->scene('type_add')->check($data)) {
                $this->error($consulting_validate->getError());
            }

            $insert = array();
            $insert['consulttype_name'] = trim(input('post.consulttype_name'));
            $insert['consulttype_sort'] = intval(input('post.consulttype_sort'));
            $insert['consulttype_introduce'] = input('post.consulttype_introduce');
            $result = model('consulttype')->addConsulttype($insert);
            if ($result) {
                $this->log('新增咨询类型', 1);
                dsLayerOpenSuccess(lang('ds_common_save_succ'));
            } else {
                $this->log('新增咨询类型', 0);
                $this->error(lang('ds_common_save_fail'));
            }
        }
        $consulttype_info = array(
            'consulttype_id' => '',
            'consulttype_name' => '',
            'consulttype_sort' => '',
            'consulttype_introduce' => '',
        );
        $this->assign('build_editor', build_editor(array(
            'name' => 'consulttype_introduce',
        )));
        $this->assign('consulttype_info', $consulttype_info);
        return $this->fetch('type_edit');
    }

    /**
     * 编辑咨询类型
     */
    public function type_edit() {
        $consulttype_model = model('consulttype');
        if (request()->isPost()) {
            // 验证
            $data = [
                'consulttype_name' => input('post.consulttype_name'),
                'consulttype_sort' => input('post.consulttype_sort'),
            ];
            $consulting_validate = validate('consulting');
            if (!$consulting_validate->scene('type_edit')->check($data)) {
                $this->error($consulting_validate->getError());
            }

            $where = array();
            $where['consulttype_id'] = intval(input('post.consulttype_id'));
            $update = array();
            $update['consulttype_name'] = trim(input('post.consulttype_name'));
            $update['consulttype_sort'] = intval(input('post.consulttype_sort'));
            $update['consulttype_introduce'] = input('post.consulttype_introduce');
            $result = $consulttype_model->editConsulttype($where, $update);
            if ($result) {
                $this->log('编辑咨询类型 ID:' . $where['consulttype_id'], 1);
                dsLayerOpenSuccess(lang('ds_common_op_succ'));
            } else {
                $this->log('编辑咨询类型 ID:' . $where['consulttype_id'], 0);
                $this->error(lang('ds_common_op_fail'));
            }
        }

        $consulttype_id = intval(input('param.consulttype_id'));
        if ($consulttype_id <= 0) {
            $this->error(lang('param_error'));
        }
        $consulttype_info = $consulttype_model->getConsulttypeInfo(array('consulttype_id' => $consulttype_id));
        $this->assign('build_editor', build_editor(array(
            'name' => 'consulttype_introduce',
            'content' => htmlspecialchars_decode($consulttype_info['consulttype_introduce']),
        )));
        $this->setAdminCurItem('type_list');
        $this->assign('consulttype_info', $consulttype_info);
        return $this->fetch();
    }

    /**
     * 删除咨询类型
     */
    public function type_del() {
        $consulttype_id = input('param.consulttype_id');
        $consulttype_id_array = ds_delete_param($consulttype_id);
        if ($consulttype_id_array === FALSE) {
            ds_json_encode('10001', lang('param_error'));
        }
        $condition=array();
        $condition['consulttype_id']=array('in',$consulttype_id_array);
        $result = model('consulttype')->delConsulttype($condition);
        if ($result) {
            $this->log('删除咨询类型 ID:' . $consulttype_id, 1);
            ds_json_encode('10000', lang('ds_common_op_succ'));
        } else {
            $this->log('删除咨询类型 ID:' . $consulttype_id, 0);
            ds_json_encode('10001', lang('ds_common_op_fail'));
        }
    }

    /**
     * 获取卖家栏目列表,针对控制器下的栏目
     */
    protected function getAdminItemList() {
        $menu_array = array(
            array(
                'name' => 'index',
                'text' => '管理',
                'url' => url('Consulting/consulting')
            ),
            array(
                'name' => 'type_list',
                'text' => '咨询类型',
                'url' => url('Consulting/type_list')
            ),
            array(
                'name' => 'type_add',
                'text' => '新增类型',
                'url' =>"javascript:dsLayerOpen('".url('Consulting/type_add')."','新增类型')"

            )
        );
        return $menu_array;
    }

}