float4x4 viewProjMatrix;
float4x4 inverseWorldView;
float4 derived_scene_colour;
float4 light_position_view_space0;
float4 derived_light_diffuse0;

float4 worldMatrix3x4Array[240]; //240 = 80*3

struct VS_IN
{
    float4	Position : POSITION;
    float4	Normal : NORMAL;
    float4	BlendWeights : BLENDWEIGHT0;
    float4	BlendIndicies : BLENDINDICES0;
    float2	Tex : TEXCOORD0;
};

struct VS_OUT
{
    float4 Position : POSITION;
    float4 Color : TEXCOORD1;
    float2 Tex : TEXCOORD0;
};

VS_OUT main(VS_IN input)
{
    VS_OUT output;
	
	float4x4 worldMatrix;
	int idx = int(input.BlendIndicies[0]) * 3;
	worldMatrix[0] = worldMatrix3x4Array[idx];
	worldMatrix[1] = worldMatrix3x4Array[idx + 1];
	worldMatrix[2] = worldMatrix3x4Array[idx + 2];
	worldMatrix[3] = float4( 0, 0, 0, 1 );

	float4 worldPos = mul(worldMatrix, input.Position);
	output.Position = mul(viewProjMatrix, worldPos);
    
    // Lighting
    float4 worldNormal = mul(worldMatrix, input.Normal);
    float3 normalView = normalize(mul(inverseWorldView, worldNormal).xyz);
    float nDotL = dot(normalView, light_position_view_space0.xyz);
    
    output.Color = float4(derived_scene_colour.xyz + derived_light_diffuse0.xyz * saturate(nDotL), 1);
    output.Color = saturate(output.Color);
    
	output.Tex = input.Tex;
	return output;
}