
float4x4	worldViewProj;
float4x4	worldViewIT;

float4	light_position_view_space0;
float4	derived_light_diffuse0;

float4x4	texture_matrix0;

struct VS_IN
{
    float4	Position : POSITION;
    float4	Normal : NORMAL0;
    float2  Tex : TEXCOORD0;
    float4  Color : COLOR0;
};

struct VS_OUT
{
    float4	Position : POSITION;
    float4  Color : TEXCOORD1;
    float2  Tex : TEXCOORD0;
};

VS_OUT main(VS_IN input) 
{
    VS_OUT output;
    output.Color = input.Color;
	
    // Lighting
    float3 normalView = normalize(mul((float3x3)worldViewIT, input.Normal));
    float nDotL = dot(normalView, light_position_view_space0.xyz);
    
    output.Color.xyz += derived_light_diffuse0.xyz * saturate(nDotL);
        
	output.Tex = mul(texture_matrix0, float4(input.Tex, 1.0, 1.0)).xy;
    output.Position = mul(worldViewProj, input.Position);
    
    return output;
}
