
float4x4	worldMatrixArray[50];
float4x4	viewProj;
float4x4    worldViewIT;

float4	derived_scene_colour;
float4	light_position_view_space0;
float4	derived_light_diffuse0;

float4x4	texture_matrix0;

struct VS_IN
{
    float4	Position : POSITION;
    float4	Normal : NORMAL;
    float4	BlendWeights : BLENDWEIGHT0;
    float4	BlendIndicies : BLENDINDICES0;
    float2	Tex : TEXCOORD0;
};

struct VS_OUT
{
    float4  Position : POSITION;
    float4	Color : TEXCOORD1;
    float2	Tex : TEXCOORD0;
};

VS_OUT main(VS_IN input) 
{	
    VS_OUT output;
	float4 finalPos = float4(0.0, 0.0, 0.0, 1.0);
	float3 finalNorm = float3(0.0, 0.0, 0.0);

	//Calculate position
	for (int i = 0; i < 4; ++i)
	{
		finalPos += mul(worldMatrixArray[int(input.BlendIndicies[i])], input.Position) * input.BlendWeights[i];
        finalNorm += (mul(worldMatrixArray[int(input.BlendIndicies[i])], float4(input.Normal.xyz,0.0)) * input.BlendWeights[i]).xyz;
	}
	finalPos.w = 1.0;
	finalNorm = normalize(finalNorm);
	
	//BWA HA HA HA - Fat Avatar!
	//finalPos += float4(finalNorm*0.15, 0.0);
	output.Position = mul(viewProj, finalPos);

	// Lighting
    float3 normalView = normalize(mul((float3x3)worldViewIT, finalNorm));
    float nDotL = dot(normalView, light_position_view_space0.xyz);
	
    output.Color = float4(derived_scene_colour.xyz + derived_light_diffuse0.xyz * saturate(nDotL), 1);
    
    
	//Send the tex coords through
	output.Tex = mul(texture_matrix0, float4(input.Tex.xy, 1.0, 1.0)).xy;
    
    return output;
}
