require "fonthelper"

local assets =
{
	Asset("ANIM", "data/anim/ds_pig_basic.zip"),
	Asset("ANIM", "data/anim/ds_pig_actions.zip"),
	Asset("ANIM", "data/anim/ds_pig_attacks.zip"),
	Asset("ANIM", "data/anim/pig_build.zip"),
	Asset("ANIM", "anim/pigzombie.zip"),
	Asset("ANIM", "data/anim/pigspotted_build.zip"),
	Asset("ANIM", "data/anim/pig_guard_build.zip"),
	Asset("ANIM", "data/anim/werepig_build.zip"),
	Asset("ANIM", "data/anim/werepig_basic.zip"),
	Asset("ANIM", "data/anim/werepig_actions.zip"),
	Asset("SOUND", "data/sound/pig.fsb"),
}

local prefabs =
{
    "meat",
    "monstermeat",
    "poop",
    "tophat",
    "strawhat",
    "pigskin",
}

local FONTS = {
	{ filename = "data/fonts/opensans50.zip", alias = DIALOGFONT },
}

AddFontAssets( assets, FONTS )

local MAX_TARGET_SHARES = 5
local SHARE_TARGET_DIST = 30
local ZOMBIE_TARGET_DIST = 60
local ZOMBIE_RUN_SPEED = 1
local ZOMBIE_WALK_SPEED = 1
local ZOMBIE_ATTACK_PERIOD = 3
local ZOMBIE_DAMAGE = 23
local ZOMBIE_HEALTH = 125
local ZOMBIE_WALL_TARGET_DIST = 2

local function OnAttacked(inst, data)
    --print(inst, "OnAttacked")
    local attacker = data.attacker

    inst.components.combat:SetTarget(attacker)

    --if inst:HasTag("werepig") then
        --inst.components.combat:ShareTarget(attacker, SHARE_TARGET_DIST, function(dude) return dude:HasTag("werepig") end, MAX_TARGET_SHARES)
    --elseif inst:HasTag("guard") then
           -- inst.components.combat:ShareTarget(attacker, SHARE_TARGET_DIST, function(dude) return dude:HasTag("pig") and (dude:HasTag("guard") or not attacker:HasTag("pig")) end, MAX_TARGET_SHARES)
    --else
        --if not (attacker:HasTag("pig") and attacker:HasTag("guard") ) then
            --inst.components.combat:ShareTarget(attacker, SHARE_TARGET_DIST, function(dude) return dude:HasTag("pig") and not dude:HasTag("werepig") end, MAX_TARGET_SHARES)
        --end
    --end
end

local function OnNewTarget(inst, data)
    --if inst:HasTag("werepig") then
        --print(inst, "OnNewTarget", data.target)
        --inst.components.combat:ShareTarget(data.target, SHARE_TARGET_DIST, function(dude) return dude:HasTag("werepig") end, MAX_TARGET_SHARES)
    --end
end

local builds = {"pigzombie", "pigspotted_build"}
local guardbuilds = {"pig_guard_build"}


local function RetargetFn(inst)
    local newtarget = 
			--[[
			FindEntity(inst, ZOMBIE_WALL_TARGET_DIST, 
				function(guy)
				return (guy:HasTag("wall") or guy:HasTag("character") )
					   and not guy:HasTag("zombie")
					   and inst.components.combat:CanTarget(guy)
				end) 
			or	]]--
			FindEntity(inst, ZOMBIE_TARGET_DIST,
				function(guy)
				return	guy:HasTag("character")
						and not guy:HasTag("zombie")
						and inst.components.combat:CanTarget(guy)
				end)
	return newtarget
end

local function KeepTargetFn(inst, target)
    --give up on dead guys, or guys in the dark, or werepigs
    return inst.components.combat:CanTarget(target)
           --and (not target.LightWatcher or target.LightWatcher:IsInLight())
           --and not (target.sg and target.sg:HasStateTag("transform") )
end



local function common()
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
	local sound = inst.entity:AddSoundEmitter()
	local shadow = inst.entity:AddDynamicShadow()
	shadow:SetSize( 1.5, .75 )
	
	inst.structuresDestroyed = 0
	
    inst.Transform:SetFourFaced()

    inst.entity:AddLightWatcher()
    inst.entity:AddLabel()
	
	inst:AddTag("zombie")
	
    inst.Label:SetFontSize(24)
    inst.Label:SetFont(TALKINGFONT)
    inst.Label:SetPos(0,3.8,0)
    --inst.Label:SetColour(180/255, 50/255, 50/255)
    inst.Label:Enable(false)

    MakeCharacterPhysics(inst, 50, .5)
    
    inst:AddComponent("locomotor") -- locomotor must be constructed before the stategraph
    inst.components.locomotor.runspeed = ZOMBIE_RUN_SPEED 
    inst.components.locomotor.walkspeed = ZOMBIE_WALK_SPEED 
	
    anim:SetBank("pigman")
    anim:PlayAnimation("idle_loop")
    anim:Hide("hat")
	inst.build = "pigzombie"
	inst.AnimState:SetBuild(inst.build)
	
    ------------------------------------------
    inst:AddComponent("combat")
    inst.components.combat.hiteffectsymbol = "pig_torso"
    inst.components.combat:SetDefaultDamage(ZOMBIE_DAMAGE)
    inst.components.combat:SetAttackPeriod(ZOMBIE_ATTACK_PERIOD)
    inst.components.combat:SetKeepTargetFunction(KeepTargetFn)
    inst.components.combat:SetRetargetFunction(3, RetargetFn)
    inst.components.combat:SetTarget(nil)
	
    MakeMediumBurnableCharacter(inst, "pig_torso")
	--MakeSmallPropagator(inst)
    ------------------------------------------
    inst:AddComponent("health")
	inst.components.health:SetMaxHealth(ZOMBIE_HEALTH)
	
    ------------------------------------------

    inst:AddComponent("inventory")
    inst:AddComponent("inspectable")
	inst:AddComponent("talker")
    ------------------------------------------

    inst:AddComponent("lootdropper")
	inst.components.lootdropper:SetLoot({})
    inst.components.lootdropper:AddRandomLoot("rottenegg",4)
	inst.components.lootdropper:AddRandomLoot("spoiled_food",2)
	inst.components.lootdropper:AddRandomLoot("powcake",1)
    inst.components.lootdropper.numrandomloot = 1

    ------------------------------------------
	
	local brain = require "brains/zombiebrain"
    inst:SetBrain(brain)
    inst:SetStateGraph("SGpigzombie")
    
    inst.OnSave = function(inst, data)
        
    end        
    
    inst.OnLoad = function(inst, data)    

    end           
    
    inst:ListenForEvent("attacked", OnAttacked)    
    inst:ListenForEvent("newcombattarget", OnNewTarget)
		
    inst.Label:Enable(true)
	
    return inst
end



return Prefab( "common/characters/pigzombie", common, assets, prefabs)
