local assets=
{
	Asset("ANIM", "data/anim/blow_dart.zip"),
	Asset("ANIM", "data/anim/swap_blowdart.zip"),
	Asset("ANIM", "data/anim/swap_blowdart_pipe.zip"),
    
    Asset("IMAGE", "data/inventoryimages/blowdart_sleep.tex"),
    Asset("IMAGE", "data/inventoryimages/blowdart_fire.tex"),
    Asset("IMAGE", "data/inventoryimages/blowdart_pipe.tex"),
	Asset("IMAGE", "inventoryimages/bomb_cherry.tex"),
	Asset("IMAGE", "inventoryimages/bomb_incendiary.tex"),
	Asset("IMAGE", "inventoryimages/bomb_fleschette.tex"),
}

local prefabs = 
{
    "impact",
}

local FLESCHETTE_RANGE = 3
local FLESCHETTE_DAMAGE = 68

local function onequip(inst, owner) 
    owner.AnimState:OverrideSymbol("swap_object", "swap_blowdart", "swap_blowdart")
    owner.AnimState:Show("ARM_carry") 
    owner.AnimState:Hide("ARM_normal") 
end

local function onunequip(inst, owner) 
    owner.AnimState:ClearOverrideSymbol("swap_object")
    owner.AnimState:Hide("ARM_carry") 
    owner.AnimState:Show("ARM_normal") 
end

local function onhit(inst, attacker, target)
    local impactfx = SpawnPrefab("impact")
    if impactfx then
	    local follower = impactfx.entity:AddFollower()
	    follower:FollowSymbol(target.GUID, target.components.combat.hiteffectsymbol, 0, 0, 0 )
        impactfx:FacePoint(Vector3(attacker.Transform:GetWorldPosition()))
    end
    inst:Remove()
end

local function onthrown(inst, data)
    inst.AnimState:SetOrientation( ANIM_ORIENTATION.OnGround )
end

local function common()
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)
    
    anim:SetBank("blow_dart")
    anim:SetBuild("blow_dart")
    
    inst:AddTag("blowdart")
    inst:AddTag("sharp")
    
    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(0)
    inst.components.weapon:SetRange(8, 10)
    
    inst:AddComponent("projectile")
    inst.components.projectile:SetSpeed(60)
    inst.components.projectile:SetOnHitFn(onhit)
    inst:ListenForEvent("onthrown", onthrown)
    -------
    
    inst:AddComponent("inspectable")
    
    inst:AddComponent("inventoryitem")
    
    inst:AddComponent("stackable")
    
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip(onequip)
    inst.components.equippable:SetOnUnequip(onunequip)
    inst.components.equippable.equipstack = true
    
    return inst
end

local function sleepthrown(inst)
    inst.AnimState:PlayAnimation("dart_purple")
end
local function sleepcanattack(inst, target)
    return target.components.sleeper
end
local function sleepattack(inst, attacker, target)
    if target.components.sleeper and not (inst.components.freezable and inst.components.freezable:IsFrozen() ) then
        target.SoundEmitter:PlaySound("dontstarve/wilson/blowdart_impact_sleep")
        target.components.sleeper:AddSleepiness(1, 15)
        if target.components.combat then
            target.components.combat:SuggestTarget(attacker)
        end
        if target.sg and not target.sg:HasStateTag("sleeping") and target.sg.sg.states.hit then
            target.sg:GoToState("hit")
        end
    end
end
local function sleep()
    local inst = common()
    
    inst:AddTag("sleepdart")
    inst.AnimState:PlayAnimation("idle_purple")
    inst.components.weapon:SetOnAttack(sleepattack)
    inst.components.weapon:SetCanAttack(sleepcanattack)
    inst.components.projectile:SetOnThrownFn(sleepthrown)
   
    return inst
end

local function firethrown(inst)
    inst.AnimState:PlayAnimation("dart_red")
end

local function cherrycanattack(inst, target)
    return true
end

local function cherryattack(inst, attacker, target)
    target.SoundEmitter:PlaySound("dontstarve/wilson/blowdart_impact_fire")
    target:PushEvent("attacked", {attacker = attacker, damage = 0})
    if target.components.burnable then
        --target.components.burnable:Ignite()
    end
    if target.components.freezable then
        --target.components.freezable:Unfreeze()
    end
    if target.components.health then
        --target.components.health:DoFireDamage(0)
    end
    if target.components.combat then
        target.components.combat:SuggestTarget(attacker)
    end
    if target.sg and target.sg.sg.states.hit then
        target.sg:GoToState("hit")
    end
	local explosive = SpawnPrefab("bombexplosive")
	if explosive then
		if explosive.components.explosive then
			explosive.components.explosive.lightonexplode = false
		end
		explosive.Physics:Teleport(target:GetPosition():Get())
		if explosive.components.burnable then
			explosive.components.burnable:Ignite()
		end
	end
end

local function incendiarycanattack(inst, target)
    return true
end
local function incendiaryattack(inst, attacker, target)
    target.SoundEmitter:PlaySound("dontstarve/wilson/blowdart_impact_fire")
    target:PushEvent("attacked", {attacker = attacker, damage = 0})
    if target.components.burnable then
        target.components.burnable:Ignite()
    end
    if target.components.freezable then
        --target.components.freezable:Unfreeze()
    end
    if target.components.health then
        target.components.health:DoFireDamage(0)
    end
    if target.components.combat then
        target.components.combat:SuggestTarget(attacker)
    end
    if target.sg and target.sg.sg.states.hit then
        target.sg:GoToState("hit")
    end
	local explosive = SpawnPrefab("bombexplosive")
	if explosive then
		if explosive.components.explosive then
			explosive.components.explosive.lightonexplode = false
		end
		explosive.Physics:Teleport(target:GetPosition():Get())
		if explosive.components.burnable then
			explosive.components.burnable:Ignite()
		end
	end
end

local function fleschettecanattack(inst, target)
    return true
end

function fleschetteattack(inst, attacker, target)   
    target.SoundEmitter:PlaySound("dontstarve/wilson/blowdart_impact_fire")
    target:PushEvent("attacked", {attacker = attacker, damage = 0})
    local pos = Vector3(target.Transform:GetWorldPosition())
    
    GetClock():DoLightningLighting()
    
    GetPlayer().components.playercontroller:ShakeCamera(target, "FULL", 0.7, 0.02, .5, 40)

    local ents = TheSim:FindEntities(pos.x, pos.y, pos.z, FLESCHETTE_RANGE)

    for k,v in pairs(ents) do
		if v.components.combat and not v:HasTag("wall") then
			v.components.combat:GetAttacked(attacker, FLESCHETTE_DAMAGE, nil)
		end
    end
end

local function cherry()
    local inst = common()

    inst:AddTag("cherrybomb")
    inst.AnimState:PlayAnimation("idle_red")
    inst.components.weapon:SetOnAttack(cherryattack)
    inst.components.weapon:SetCanAttack(cherrycanattack)
    inst.components.projectile:SetOnThrownFn(firethrown)
	inst:AddComponent("explosive")
	inst.components.stackable.stacksize=4
    
    return inst
end

local function incendiary()
    local inst = common()

    inst:AddTag("incendiarybomb")
    inst.AnimState:PlayAnimation("idle_red")
    inst.components.weapon:SetOnAttack(incendiaryattack)
    inst.components.weapon:SetCanAttack(incendiarycanattack)
    inst.components.projectile:SetOnThrownFn(firethrown)
	inst:AddComponent("explosive")
	inst.components.stackable.stacksize=4
    
    return inst
end

local function fleschette()
    local inst = common()

    inst:AddTag("fleschettebomb")
    inst.AnimState:PlayAnimation("idle_red")
    inst.components.weapon:SetOnAttack(fleschetteattack)
    inst.components.weapon:SetCanAttack(fleschettecanattack)
    inst.components.projectile:SetOnThrownFn(firethrown)
	inst:AddComponent("explosive")
    inst.components.stackable.stacksize=4
	
    return inst
end

local function pipeequip(inst, owner) 
    owner.AnimState:OverrideSymbol("swap_object", "swap_blowdart_pipe", "swap_blowdart_pipe")
    owner.AnimState:Show("ARM_carry") 
    owner.AnimState:Hide("ARM_normal") 
end

local function pipethrown(inst)
    inst.AnimState:PlayAnimation("dart_pipe")
end
local function pipe()
    local inst = common()

    inst.AnimState:PlayAnimation("idle_pipe")

    inst.components.equippable:SetOnEquip(pipeequip)
    inst.components.weapon:SetDamage(TUNING.PIPE_DART_DAMAGE)
    inst.components.projectile:SetOnThrownFn(pipethrown)
    
    return inst
end

return Prefab( "common/inventory/bomb_cherry", cherry, assets, prefabs),
		Prefab( "common/inventory/bomb_incendiary", incendiary, assets, prefabs),
		Prefab( "common/inventory/bomb_fleschette", fleschette, assets, prefabs)
