local Zombies = Class(function(self, inst)
	self.inst = inst
	inst:ListenForEvent( "nighttime", function() self:OnNight() end, GetWorld())
	print("component")
end)

ZOMBIE_SPAWN_DIST = 25

function Zombies:GetSpawnPoint(pt)
    local theta = math.random() * 2 * PI
    local radius = ZOMBIE_SPAWN_DIST

	local offset = FindWalkableOffset(pt, theta, radius, 12, true)
	if offset then
		return pt+offset
	end
end



function Zombies:SpawnForNight(night)
	local pt = Vector3(GetPlayer().Transform:GetWorldPosition())	
	local spawn_pt = self:GetSpawnPoint(pt)
	local player = GetPlayer()
	local zombiecount = math.floor(math.pow(night, 1.2))
	print("night ".. tostring(night) .. " : Zombies " .. zombiecount)
	for x = 0, zombiecount do
		spawn_pt = self:GetSpawnPoint(pt)
		if player and spawn_pt then
			local zombie = SpawnPrefab("pigzombie")
			if zombie then
				zombie.Physics:Teleport(spawn_pt:Get())
				zombie:FacePoint(pt)
				zombie.components.combat:SuggestTarget(player)
			end
		end
	end
end

function Zombies:OnNight()
	local night = GetClock().numcycles
	
	self:SpawnForNight(night)
end

return Zombies