require "behaviours/chaseandattack"
require "behaviours/runaway"
require "behaviours/attackwall"

local RUN_AWAY_DIST = 5
local STOP_RUN_AWAY_DIST = 8
local MAX_CHASE_TIME = 10
local MAX_CHASE_DIST = 30
local START_FACE_DIST = 6
local KEEP_FACE_DIST = 8
local SEE_DIST = 3

local ZombieBrain = Class(Brain, function(self, inst)
    Brain._ctor(self, inst)
end)

local function BaseDestroy(inst)
	local target = FindEntity(inst, SEE_DIST, function(item) 
		if item.components.workable
			and item.components.workable.action == ACTIONS.HAMMER
			and not item:HasTag("wall")
			then
				return true
			end
		end)
	if target then
		return BufferedAction(inst, target, ACTIONS.HAMMER)
	end
end

local function CanDestroyBase(inst)
    return inst.structuresDestroyed and inst.structuresDestroyed < 2
end

local function GetFaceTargetFn(inst)
    local target = GetClosestInstWithTag("player", inst, START_FACE_DIST)
    if target and not target:HasTag("notarget") then
        return target
    end
end

local function KeepFaceTargetFn(inst, target)
    return inst:GetDistanceSqToInst(target) <= KEEP_FACE_DIST*KEEP_FACE_DIST and not target:HasTag("notarget")
end

function ZombieBrain:OnStart()
    --print(self.inst, "PigBrain:OnStart")   
    
    local root = 
        PriorityNode(
        {
			AttackWall(self.inst),
			DoAction(self.inst, function() return BaseDestroy(self.inst) end, "DestroyBase", true),
            ChaseAndAttack(self.inst),
            Wander(self.inst)
			
			--AttackWall(self.inst),
			--WhileNode( function() return self.inst.components.combat.target == nil or not self.inst.components.combat:InCooldown() end, "AttackMomentarily",
			--WhileNode(function() return CanDestroyBase(self.inst) end, "CanDestroy",
					
			--ChaseAndAttack(self.inst, MAX_CHASE_TIME, MAX_CHASE_DIST),
			--WhileNode( function() return self.inst.components.combat.target and self.inst.components.combat:InCooldown() end, "Dodge",
				--RunAway(self.inst, function() return self.inst.components.combat.target end, RUN_AWAY_DIST, STOP_RUN_AWAY_DIST) ),  
			--FaceEntity(self.inst, GetFaceTargetFn, KeepFaceTargetFn),				
        }, 1)
    
    self.bt = BT(self.inst, root)
    
end

return ZombieBrain
