
local assets=
{
	Asset("ANIM", "anim/ornamented_vase.zip"),
	Asset("ATLAS", "images/inventoryimages/ornamented_vase.xml"),
	Asset("IMAGE", "images/inventoryimages/ornamented_vase.tex"),
}

local prefabs = 
{
    "goldnugget",
}

SetSharedLootTable( 'ornamented_vase',
{
    {'goldnugget',  1.0},
    {'goldnugget',  1.0},
    {'goldnugget',	1.0},
	{'goldnugget',  1.0},
    {'goldnugget',  1.0},
    {'goldnugget',	0.5},
    {'goldnugget',	0.25},	
})

local function onhammered(inst, worker)
    SpawnPrefab("collapse_small").Transform:SetPosition(inst.Transform:GetWorldPosition())
    inst.components.lootdropper:DropLoot()
    inst.SoundEmitter:PlaySound("dontstarve/common/destroy_pot")
    inst:Remove()
end

local function onbuilt(inst)
	inst.AnimState:PushAnimation("idle_closed", false)
end

local function fn(Sim)
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    MakeObstaclePhysics(inst, 0.8)
	
    local minimap = inst.entity:AddMiniMapEntity()
	minimap:SetIcon("cave_closed.png")
	
    anim:SetBank("cave_entrance")
    anim:SetBuild("ornamented_vase")
	anim:PlayAnimation("idle_closed")  	
	
    inst:AddTag("structure")	
	
    inst:AddComponent("inspectable")
	
	inst.entity:AddMiniMapEntity()	
	inst.MiniMapEntity:SetIcon( "ornamented_vase.tex" )	
	
	inst:AddComponent("sanityaura")
	
	inst:AddComponent("lootdropper")
	inst.components.lootdropper:SetChanceLootTable('ornamented_vase')
	inst:AddComponent("norecipelootdrop")	

    inst:AddComponent("workable")
	inst.components.workable:SetWorkAction(ACTIONS.HAMMER)
	inst.components.workable:SetWorkLeft(3)
	inst.components.workable:SetOnFinishCallback(onhammered)
	
	inst:ListenForEvent( "onbuilt", onbuilt)		
    return inst
end

return Prefab( "common/ornamented_vase", fn, assets, prefabs)