local STRINGS = GLOBAL.STRINGS
local Ingredient = GLOBAL.Ingredient
local RECIPETABS = GLOBAL.RECIPETABS
TECH = GLOBAL.TECH
Recipe = GLOBAL.Recipe

PrefabFiles = {"ornamented_vase",}

local assets=
{
    Asset("ATLAS", "images/inventoryimages/ornamented_vase.xml"),
    Asset("IMAGE", "images/inventoryimages/ornamented_vase.tex"),
}

GLOBAL.STRINGS.NAMES.ORNAMENTED_VASE = "Ornamented Vase"
GLOBAL.STRINGS.RECIPE_DESC.ORNAMENTED_VASE = "A heavy monument of greed!"


	local ornamented_vase_goldnugget = 16
	local ornamented_vase_greengem = 2
	local ornamented_vase_redgem = 4

	local ornamented_vaseCraftingCost = (GetModConfigData("CraftingCost"))
	if ornamented_vaseCraftingCost == "Easy" then
		ornamented_vase_goldnugget = 6
		ornamented_vase_greengem = 2
		ornamented_vase_redgem = 4
	elseif ornamented_vaseCraftingCost == "Expensive" then
		ornamented_vase_goldnugget = 30
		ornamented_vase_greengem = 2
		ornamented_vase_redgem = 4
	end


		local ornamented_vase = GLOBAL.Recipe("ornamented_vase",
    {
        Ingredient("goldnugget", ornamented_vase_goldnugget),
        Ingredient("greengem",ornamented_vase_greengem),
        Ingredient("redgem", ornamented_vase_redgem)
    },
        RECIPETABS.TOWN, TECH.MAGIC_THREE, "pottedfern_placer" ) 
		ornamented_vase.atlas = "images/inventoryimages/ornamented_vase.xml"
		


GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.ORNAMENTED_VASE = "I can come back here when life will give me a misery."

GLOBAL.STRINGS.CHARACTERS.WILLOW.DESCRIBE.ORNAMENTED_VASE = "Well, I found a 'good' way to use this gold."

GLOBAL.STRINGS.CHARACTERS.WOLFGANG.DESCRIBE.ORNAMENTED_VASE = "Wolfgang begins to like this object."

GLOBAL.STRINGS.CHARACTERS.WENDY.DESCRIBE.ORNAMENTED_VASE = "It shines like a beacon in the darkness."

GLOBAL.STRINGS.CHARACTERS.WX78.DESCRIBE.ORNAMENTED_VASE = "OBJECT OF HUMAN DESIRE.. ONE OF MANY."

GLOBAL.STRINGS.CHARACTERS.WICKERBOTTOM.DESCRIBE.ORNAMENTED_VASE = "It seems that it is not easy to resist collecting valuables."

GLOBAL.STRINGS.CHARACTERS.WOODIE.DESCRIBE.ORNAMENTED_VASE = "I created something very expensive. I like it."

GLOBAL.STRINGS.CHARACTERS.WAXWELL.DESCRIBE.ORNAMENTED_VASE = "Apparently I'm going back to my old habits."

	if GLOBAL.IsDLCEnabled(GLOBAL.REIGN_OF_GIANTS) then 

GLOBAL.STRINGS.CHARACTERS.WATHGRITHR.DESCRIBE.ORNAMENTED_VASE = "For a warrior, glory should mean more than treasures!"

GLOBAL.STRINGS.CHARACTERS.WEBBER.DESCRIBE.ORNAMENTED_VASE = "We will take care of this massive trinket for sure!"
	end
	
	
	function lootdropperpostinit(inst)

	inst.GenerateLoot = function(self)
    local loots = {}
    
    if self.numrandomloot and math.random() <= (self.chancerandomloot or 1) then
		for k = 1, self.numrandomloot do
		    local loot = self:PickRandomLoot()
		    if loot then
			    table.insert(loots, loot)
			end
		end
	end
    
    if self.chanceloot then
		for k,v in pairs(self.chanceloot) do
			if math.random() < v.chance then
				table.insert(loots, v.prefab)
				self.droppingchanceloot = true
			end
		end
	end

    if self.chanceloottable then
    	local loot_table = GLOBAL.LootTables[self.chanceloottable]
    	if loot_table then
    		for i, entry in ipairs(loot_table) do
    			local prefab = entry[1]
    			local chance = entry[2]    			
				if math.random() <= chance then
					table.insert(loots, prefab)
					self.droppingchanceloot = true
				end
			end
		end
	end

	if not self.droppingchanceloot and self.ifnotchanceloot then
		self.inst:PushEvent("ifnotchanceloot")
		for k,v in pairs(self.ifnotchanceloot) do
			table.insert(loots, v.prefab)
		end
	end


    
    if self.loot then
		for k,v in ipairs(self.loot) do
			table.insert(loots, v)
		end
	end
	
	local recipe = GLOBAL.GetRecipe(self.inst.prefab)

	if recipe and not self.inst.components.norecipelootdrop then
	

		
		local percent = 1

		if self.inst.components.finiteuses then
			percent = self.inst.components.finiteuses:GetPercent()
		end

		for k,v in ipairs(recipe.ingredients) do
			local amt = math.ceil( (v.amount * TUNING.HAMMER_LOOT_PERCENT) * percent)
			for n = 1, amt do
				table.insert(loots, v.type)
			end
		end
	end
    
    return loots

    end


end	   

local function SanityAura(inst)
    inst.components.sanityaura.aura = (GetModConfigData("SanityAura"))
end
AddPrefabPostInit("ornamented_vase", SanityAura)
	
	
AddComponentPostInit("lootdropper", lootdropperpostinit)

AddMinimapAtlas("images/inventoryimages/ornamented_vase.xml")