declare @objectID int;
select @objectID = object_id from sys.triggers where parent_id = object_id(N'dbo.Todo') and name= N'tr_Todo_Delete';
declare @createOrAlter nvarchar(6);
set @createOrAlter = case when @objectID is null then N'create' else N'alter' end;
exec (@createOrAlter + N' trigger dbo.tr_Todo_Delete
on dbo.Todo
for delete
as 
begin
    -- v2
    set nocount on

    insert into dbo.TodoHistory (HistoryType, TodoID, ModifiedDate, ModifiedUserName, ModifiedLoggedUserName, ConnectionID, CreationDate, DueDate, Name, Priority, Data, UserInfoID, SecurityGroup, ClosedDate, IsPrivate, CustomField1, CustomField2, CustomField3)
    select ''D'', ID, getutcdate(), ModifiedUserName, ModifiedLoggedUserName, ConnectionID, CreationDate, DueDate, Name, Priority, Data, UserInfoID, SecurityGroup, ClosedDate, IsPrivate, CustomField1, CustomField2, CustomField3
    from deleted
end;');