declare @objectID int;
select @objectID = object_id from sys.triggers where parent_id = object_id(N'dbo.PamCredential') and name = N'tr_PamCredential_Update' ;
declare @createOrAlter nvarchar (6);
set @createOrAlter = case when @objectID is null then N'create' else N'alter' end;
exec (@createOrAlter + N' trigger dbo.tr_PamCredential_Update
on dbo.PamCredential
after update
as
begin
-- v1
insert PamPasswordHistory (
    ID,
    CredentialID,
    Username,
    DomainName,
    EncryptedPassword,
    CreatedBy,
    CreatedDateTime
)
select
    newid(),
    ID,
    Username,
    DomainName,
    EncryptedPassword,
    UpdatedBy,
    UpdatedDateTime
from
    deleted
end;');