if not exists (select * from sys.sysobjects where id = object_id(N'dbo.PamCredential'))
begin
    create table dbo.PamCredential(
        ID uniqueidentifier NOT NULL,
        FolderID uniqueidentifier NOT NULL constraint FK_PamCredential_FolderID foreign key references dbo.PamFolder(ID),
        AdminCredentialID uniqueidentifier NULL,
        Label nvarchar(512) NULL,
        CredentialType int NOT NULL,
        ProtectedDataType int NOT NULL,
        Protocol int NOT NULL,
        Username nvarchar(2048) NULL,
        EncryptedPassword nvarchar(max) NULL,
        IPAddress nvarchar(39) NULL,
        DomainName nvarchar(256) NULL,
        Port int NULL,
        PasswordTemplateIdentifier nvarchar(64) NULL,
        Status int NOT NULL constraint DF_PamCredential_Status default (0),
        CreatedBy nvarchar(256) NULL,
        CreatedDateTime datetime2 NULL,
        UpdatedBy nvarchar(256) NULL,
        UpdatedDateTime datetime2 NULL,
        constraint PK_PamCredential primary key clustered (ID)
    );
end;