declare @objectID int;
select @objectID = object_id from sys.triggers where parent_id = object_id(N'dbo.ConnectionLog') and name= N'tr_ConnectionLog_Delete';
declare @createOrAlter nvarchar(6);
set @createOrAlter = case when @objectID is null then N'create' else N'alter' end;
exec (@createOrAlter + N' trigger dbo.tr_ConnectionLog_Delete
on dbo.ConnectionLog
for delete
as 
begin
    set nocount on;

    delete cs
    from deleted i
        inner join dbo.ConnectionState cs on cs.ID = i.ID
    where MessageType in (4, 8)
      and SupportClose = 1;
end;');