declare @objectID int;
select @objectID = object_id from sys.triggers where parent_id = object_id(N'dbo.UserSecurity') and name= N'trUserSecurity_Update';
declare @createOrAlter nvarchar(6);
set @createOrAlter = case when @objectID is null then N'create' else N'alter' end;
exec (@createOrAlter + N' trigger dbo.trUserSecurity_Update
on dbo.UserSecurity after update
as
begin
    set nocount on;

    if (update (Name)
        or update (UserType)
        or update (IsAdministrator)
        or update (IsEnabled)
        or update (Departments)
        or update (SecurityKey)
        or update (AccountSettings)
        or update (CanAdd)
        or update (CanDelete)
        or update (CanEdit)
        or update (CustomSecurity)
        or update (CanAddCredentials)
        or update (CanAddDataEntry)
        or update (CanEditCredentials)
        or update (CanEditDataEntry)
        or update (CanDeleteCredentials)
        or update (CanDeleteDataEntry)
        or update (UPN)
        or update (AuthenticationType)
        or update (LoginEmail)
        or update (Repositories)
        or update (HasAccessRDM)
        or update (HasAccessPVM)
        or update (HasAccessWeb)
        or update (HasAccessWebLogin)
        or update (UserLicenceTypeMode)
        or update (HasAccessLauncher))
    begin
        update dbo.DatabaseInfo set ConnectionCacheID = newid(), IntelligentCacheID = newid();
    end
end;');