if not exists(select * from sys.tables where object_id = object_id(N'dbo.SessionRecording'))
    create table dbo.SessionRecording
    (
        ID uniqueidentifier not null constraint DF_SessionRecording_ID default newid() 
        ,ConnectionLogID uniqueidentifier not null constraint FK_SessionRecording_ConnectionLogID foreign key references dbo.ConnectionLog(ID)
        ,CreationDate datetime not null constraint DF_SessionRecording_CreationDate default getutcdate()
        ,RecordingType int not null
        ,FileSize Int not null
        ,ItemIndex Int not null
        ,Folder nvarchar(256) null
        ,StartTime int not null
        ,Duration int null
        ,HashValue varbinary(64) not null
        ,Data nvarchar(max) null
        ,Flags int not null constraint DF_SessionRecording_Flags default(0)
        ,constraint PK_SessionRecording primary key clustered (ID asc)
    )