declare @objectID int;
select @objectID = object_id from sys.triggers where parent_id = object_id(N'dbo.Repository') AND name = N'tr_Repository_Delete';
declare @createOrAlter nvarchar(6);
set @createOrAlter = case when @objectID is null then N'create' else N'alter' end;
exec (@createOrAlter + N' trigger dbo.tr_Repository_Delete
on dbo.Repository
for delete
as
begin
	set nocount on;

    insert into dbo.RepositoryHistory (HistoryType, RepositoryID, Name, Description, ModifiedDate, ModifiedUserName, ModifiedLoggedUserName, RepositoryType, Icon)
    select ''D'', ID, Name, Description, GETUTCDATE(), ModifiedUserName, ModifiedLoggedUserName, RepositoryType, Icon
    from deleted;
end;');