declare @objectID int;
select @objectID = object_id from sys.triggers where parent_id = object_id(N'dbo.ConnectionHandbook') and name= N'tr_ConnectionHandbook_Delete';
declare @createOrAlter nvarchar(6);
set @createOrAlter = case when @objectID is null then N'create' else N'alter' end;
exec (@createOrAlter + N' trigger dbo.tr_ConnectionHandbook_Delete
on dbo.ConnectionHandbook
for delete
as
begin
	set nocount on;
    
    insert into dbo.ConnectionHandbookHistory (HistoryType, ConnectionHandbookID, ConnectionID, Name, Data, GroupName, ModifiedDate, ModifiedUserName, ModifiedLoggedUserName, SortPriority, IsDefault)
    select ''D'', ID, ConnectionID, Name, Data, GroupName, getutcdate(), ModifiedUserName, ModifiedLoggedUserName, SortPriority, IsDefault from deleted;
end;');