declare @objectID int;
select @objectID = object_id from sys.triggers where parent_id = object_id(N'dbo.ConnectionLog') and name= N'tr_ConnectionLog_Update';
declare @createOrAlter nvarchar(6);
set @createOrAlter = case when @objectID is null then N'create' else N'alter' end;
exec (@createOrAlter + N' trigger dbo.tr_ConnectionLog_Update
on dbo.ConnectionLog
for update
as 
begin
    set nocount on;

    delete cs
    from inserted i
        inner join dbo.ConnectionState cs on cs.ID = i.ID
    where MessageType in (4, 8)
      and SupportClose = 1
      and EndDateTime is not null;
end;');