declare @execute nvarchar(max)

declare default_cursor cursor for 
select N'sp_rename ''[' + s.name + N'].[' + t.name + N'].[' + c.name + N']'', ''PK_' + t.name + N'''' as excecute
from sys.key_constraints c
    inner join sys.tables t on c.parent_object_id = t.object_id
    inner join sys.schemas s on s.schema_id = t.schema_id
where c.name like 'PK~_~_%' escape '~'
  and t.name in ('AppSettings', 'Attachment', 'BackupJob', 'BackupJobUser', 'BackupLog', 'ConnectionGroup', 'ConnectionHandbook', 'ConnectionHandbookHistory', 'ConnectionHistory', 'ConnectionLog', 'Connections', 'ConnectionState', 'Credential', 'CustomImage', 'DatabaseInfo', 'DataSourceSettingHistory', 'GroupInfo', 'GroupInfoHistory', 'Inventory', 'LoginAttempt', 'LoginHistory', 'LogMessage', 'Repository', 'RepositoryHistory', 'Subscription', 'SubscriptionEvent', 'Todo', 'TodoHistory', 'UserAccount', 'UserGroupInfo', 'UserInfoHistory', 'UserProfile', 'UserRoamingSettings', 'UserRole', 'UserSecurity')
  and s.name = 'dbo';

open default_cursor
fetch next from default_cursor into @execute

while @@FETCH_STATUS = 0
begin
    exec sp_executesql @execute;
    fetch next from default_cursor into @execute
end

close default_cursor
deallocate default_cursor