declare @drop nvarchar(max)
declare @create nvarchar(max)

declare default_cursor cursor for 
with cteFK as (select N'[' + s.Name + N'].[' + t.name + N']' as TableName, f.name AS ForeignKey, 
            t.name as Name,
            N'[' + s.Name + N'].[' + object_name (f.referenced_object_id) + N']' AS ReferenceTableName
            ,a.[Column], a.Reference
        FROM sys.foreign_keys AS f 
            inner join sys.objects o on o.object_id = f.referenced_object_id
            inner join sys.schemas s on s.schema_id = o.schema_id
            inner join (select
                col_name(fc.parent_object_id, fc.parent_column_id) AS [Column], 
                col_name(fc.referenced_object_id, fc.referenced_column_id) AS Reference, constraint_object_id
            from sys.foreign_key_columns as fc) a on f.object_id = a.constraint_object_id
            inner join sys.tables t on t.object_id = f.parent_object_id
            inner join sys.schemas s2 on s2.schema_id = t.schema_id
            inner join (select constraint_object_id from sys.foreign_key_columns group by constraint_object_id having count(*) = 1 ) v on v.constraint_object_id = a.constraint_object_id
        where f.name like '%~_~_%' escape '~'
          and t.name in ('AppSettings', 'Attachment', 'BackupJob', 'BackupJobUser', 'BackupLog', 'ConnectionGroup', 'ConnectionHandbook', 'ConnectionHandbookHistory', 'ConnectionHistory', 'ConnectionLog', 'Connections', 'ConnectionState', 'Credential', 'CustomImage', 'DatabaseInfo', 'DataSourceSettingHistory', 'GroupInfo', 'GroupInfoHistory', 'Inventory', 'LoginAttempt', 'LoginHistory', 'LogMessage', 'Repository', 'RepositoryHistory', 'Subscription', 'SubscriptionEvent', 'Todo', 'TodoHistory', 'UserAccount', 'UserGroupInfo', 'UserInfoHistory', 'UserProfile', 'UserRoamingSettings', 'UserRole', 'UserSecurity')
          and s.name = 'dbo')
select
    N'alter table'  + TableName + N' drop constraint ' + ForeignKey as [Drop],
    N'alter table'  + TableName + N' add constraint  FK_' + Name + N'_' + [Column] + N' foreign key (' + [Column] + N') references ' + ReferenceTableName+ N'(' + Reference + N');' as [Create]
from cteFK;

open default_cursor
fetch next from default_cursor into @drop, @create

while @@FETCH_STATUS = 0
begin
    exec sp_executesql @drop;
    exec sp_executesql @create;
    fetch next from default_cursor into @drop, @create
end

close default_cursor
deallocate default_cursor