declare @execute nvarchar(max)

declare default_cursor cursor for 
select
    N'sp_rename N''' + s.name + N'.' + dc.Name + ''', ''DF_' + t.Name + N'_' + c.Name + ''', N''OBJECT''' 
from sys.default_constraints dc
    inner join sys.tables t on t.object_id = dc.parent_object_id
    inner join sys.schemas s on s.schema_id = t.schema_id
    inner join sys.all_columns c on c.object_id = t.object_id and c.column_id = dc.parent_column_id
where N'DF_' + t.name + N'_' + c.name <> dc.Name
    and t.name in ('AppSettings', 'Attachment', 'BackupJob', 'BackupJobUser', 'BackupLog', 'ConnectionGroup', 'ConnectionHandbook', 'ConnectionHandbookHistory', 'ConnectionHistory', 'ConnectionLog', 'Connections', 'ConnectionState', 'Credential', 'CustomImage', 'DatabaseInfo', 'DataSourceSettingHistory', 'GroupInfo', 'GroupInfoHistory', 'Inventory', 'LoginAttempt', 'LoginHistory', 'LogMessage', 'Repository', 'RepositoryHistory', 'Subscription', 'SubscriptionEvent', 'Todo', 'TodoHistory', 'UserAccount', 'UserGroupInfo', 'UserInfoHistory', 'UserProfile', 'UserRoamingSettings', 'UserRole', 'UserSecurity')
    and s.name = 'dbo';

open default_cursor
fetch next from default_cursor into @execute

while @@FETCH_STATUS = 0
begin
    exec sp_executesql @execute;
    fetch next from default_cursor into @execute
end

close default_cursor
deallocate default_cursor