declare @objectID int;
select @objectID = object_id from sys.triggers where parent_id = object_id(N'dbo.Todo') and name= N'tr_Todo';
declare @createOrAlter nvarchar(6);
set @createOrAlter = case when @objectID is null then N'create' else N'alter' end;
exec (@createOrAlter + N' trigger dbo.tr_Todo
on dbo.Todo
for insert, update
as 
begin
    -- v1.1
    set nocount on

    insert into dbo.TodoHistory (HistoryType, TodoID, ModifiedDate, ModifiedUserName, ModifiedLoggedUserName, ConnectionID, CreationDate, CreatedByUserName, CreatedByLoggedUserName, DueDate, Name, Priority, Data, UserInfoID, SecurityGroup, ClosedDate, IsPrivate, CustomField1, CustomField2, CustomField3, Comment, Status, AssignedToUserID)
    select case when d.ID is null then ''I'' else ''U'' end, i.ID, case when i.ModifiedDate = d.ModifiedDate then getutcdate() else isnull(i.ModifiedDate, getutcdate()) end, i.ModifiedUserName, i.ModifiedLoggedUserName, i.ConnectionID, i.CreationDate, i.CreatedByUserName, i.CreatedByLoggedUserName, i.DueDate, i.Name, i.Priority, i.Data, i.UserInfoID, i.SecurityGroup, i.ClosedDate, i.IsPrivate, i.CustomField1, i.CustomField2, i.CustomField3, i.Comment, i.Status, i.AssignedToUserID
    from inserted i
        left outer join deleted d on i.ID = d.ID
end;');