with cteUpdate as 
(
	select ConnectionID, isnull(count(distinct ID), 0) as InventoryReportCount
	from dbo.Inventory
	group by ConnectionID
)
update c
set InventoryReportCount = cte.InventoryReportCount
from dbo.Connections c
    inner join cteUpdate cte on cte.ConnectionID = c.ID
where isnull(c.InventoryReportCount, 0) <> isnull(cte.InventoryReportCount, 0);