with cteUpdate as 
(
	select ConnectionID, isnull(count(distinct ID), 0) as HandbookCount
	from dbo.ConnectionHandbook
	group by ConnectionID
)
update c
set HandbookCount = cte.HandbookCount
from dbo.Connections c
    inner join cteUpdate cte on cte.ConnectionID = c.ID
where isnull(c.HandbookCount, 0) <> isnull(cte.HandbookCount, 0);