with cteUpdate as
(
    select c.ID, isnull(count(distinct t.ID), 0) as TodoOpenCount

    from dbo.Connections c

        left outer join dbo.Todo t on t.ConnectionID = c.ID and isnull(t.Status, 0) in (0 /*Default*/, 1 /*Open*/, 2 /*Assigned*/, 3 /*InProgress*/)
	group by c.ID, c.TodoOpenCount
)
update c
set TodoOpenCount = cte.TodoOpenCount
from dbo.Connections c
    inner
join cteUpdate cte on cte.ID = c.ID
where isnull(c.TodoOpenCount, 0) <> isnull(cte.TodoOpenCount, 0);