declare @drop nvarchar(max)
declare @create nvarchar(max)

declare default_cursor cursor for 
select 'alter table [' + s.name + '].[' + t.Name + '] drop constraint ' + dc.Name as [Drop], 'alter table [' + s.name + '].[' + t.Name + '] add constraint DF_' + t.Name + '_' + c.Name + ' default getutcdate() for ' + c.Name as [Create]
from sys.default_constraints dc
    inner join sys.tables t on t.object_id = dc.parent_object_id
    inner join sys.schemas s on s.schema_id = t.schema_id
    inner join sys.all_columns c on c.object_id = t.object_id and c.column_id = dc.parent_column_id
where definition like '%getdate%';

open default_cursor
fetch next from default_cursor into @drop, @create

while @@FETCH_STATUS = 0
begin
    exec sp_executesql @drop;
    exec sp_executesql @create;
    fetch next from default_cursor into @drop, @create
end

close default_cursor
deallocate default_cursor