declare @objectID int;
select @objectID = object_id from sys.triggers where parent_id = object_id(N'dbo.ConnectionWiki') and name = N'tr_ConnectionWiki_Delete';

if object_id(N'dbo.ConnectionWiki') is not null
begin
    declare @createOrAlter nvarchar(6);
    set @createOrAlter = case when @objectID IS NULL then N'create' else N'alter' end;
    exec (@createOrAlter + N' trigger dbo.tr_ConnectionWiki_Delete
on dbo.ConnectionWiki
for delete
as
begin
	set nocount on;
    insert into dbo.ConnectionWikiHistory
    (
        HistoryType
      , ConnectionWikiID
      , ConnectionID
      , Name
      , Data
      , ModifiedDate
      , ModifiedUserName
      , ModifiedLoggedUserName
    )
    select
        ''D''
      , ID
      , ConnectionID
      , Name
      , Data
      , getutcdate()
      , ModifiedUserName
      , ModifiedLoggedUserName
	from deleted;
end;');
end;