declare @objectID int;
select @objectID = object_id from sys.triggers where parent_id = object_id(N'dbo.TodoUsers') and name= N'tr_TodoUsers';
declare @createOrAlter nvarchar(6);
set @createOrAlter = case when @objectID is null then N'create' else N'alter' end;
exec (@createOrAlter + N' trigger dbo.tr_TodoUsers
on dbo.TodoUsers
instead of insert, update
as 
begin
    set nocount on

    if (not exists(select * from inserted))
    begin
        return;
    end;

    update t
    set
        Comment = tu.TodoUsersComment
        ,Status = tu.TodoUsersStatus
        ,AssignedToUserID = tu.TodoUsersUserInfoID
    from dbo.Todo t inner join inserted tu on t.PrimaryTodoUsersID = tu.TodoUsersID
    where
        ((Comment <> tu.TodoUsersComment) or (Comment is null and tu.TodoUsersComment is not null) or (Comment is not null and tu.TodoUsersComment is null))
     or ((Status <> tu.TodoUsersStatus) or (Status is null and tu.TodoUsersStatus is not null) or (Status is not null and tu.TodoUsersStatus is null))
     or ((AssignedToUserID <> tu.TodoUsersUserInfoID) or (AssignedToUserID is null and tu.TodoUsersUserInfoID is not null) or (AssignedToUserID is not null and tu.TodoUsersUserInfoID is null))
end;');