-- delete duplicate roots
with cteGoodRoots as (select isnull(RepositoryID, '00000000-0000-0000-0000-000000000000') as RepositoryID, max(Version) as Version from dbo.Connections where ConnectionType = 92 group by RepositoryID)
    ,cteRoots as (select isnull(c.RepositoryID, '00000000-0000-0000-0000-000000000000') as RepositoryID, c.ID, c.Version from dbo.Connections c where c.ConnectionType = 92)
delete c
from dbo.Connections c
    inner join cteRoots r on r.ID = c.ID
    left outer join cteGoodRoots gr on r.RepositoryID = gr.RepositoryID and r.Version = gr.Version
where gr.RepositoryID is null;