IF NOT EXISTS (SELECT 1 FROM [sys].[procedures] WHERE [object_id] = OBJECT_ID(N'[dbo].[pr_Error_UpdateNumber]'))
    EXEC (N'
CREATE PROCEDURE [dbo].[pr_Error_UpdateNumber]
    @errorNumber INT OUTPUT
  , @errorMessage NVARCHAR(4000)
AS
BEGIN
    SET NOCOUNT ON;

    IF @errorNumber = 50000 AND @errorMessage LIKE N''\[[1-9]%'' ESCAPE N''\'' BEGIN
        DECLARE @index INT;
        SET @index = CHARINDEX(N'']'', @errorMessage);
        IF @index BETWEEN 3 AND 12 BEGIN
            BEGIN TRY
                SET @errorNumber = SUBSTRING(@errorMessage, 2, @index - 2);
            END TRY
            BEGIN CATCH
            END CATCH;
        END;
    END;

    RETURN 0;
END;');