IF NOT EXISTS (SELECT 1 FROM [sys].[procedures] WHERE [object_id] = OBJECT_ID(N'[dbo].[pr_Error_Raise]'))
    EXEC (N'
CREATE PROCEDURE [dbo].[pr_Error_Raise]
    @errorNumber INT
  , @errorMessage NVARCHAR(4000)
  , @errorSeverity INT
  , @errorState INT
AS
BEGIN
    SET NOCOUNT ON;

    IF @errorNumber <> 50000 AND @errorNumber > 0 BEGIN
        DECLARE @prefix NVARCHAR(13);
        SET @prefix = N''['' + CONVERT(NVARCHAR(10), @errorNumber) + N''] '';
        IF (LEFT(@errorMessage, LEN(@prefix)) <> @prefix)
            SET @errorMessage = @prefix + @errorMessage;
    END;

    RAISERROR (@errorMessage, @errorSeverity, @errorState);
    RETURN 1;
END;');