if not exists (select * FROM sys.sysobjects where id = object_id(N'dbo.BackupJob'))
    create table dbo.BackupJob
    (
        ID uniqueidentifier not null,
        StartDateTime datetime not null,
        Interval datetime not null,
        HistoryLength int not null,
        SuccessNotification bit not null constraint DF_BackupJob_SuccessNotification default (1),
        FailureNotification bit not null constraint DF_BackupJob_FailureNotification default (1),
        IsEnabled bit not null constraint DF_BackupJob_IsEnabled default (1),
        Path nvarchar(max) not null,
        IsEnabledDatabase bit not null constraint DF_BackupJob_IsEnabledDatabase default (1),
        PathDatabase nvarchar(max) null,
        TruncateLog bit not null constraint DF_BackupJob_TruncateLog default (0),
        CopyOnly bit not null constraint DF_BackupJob_CopyOnly default (0),
        SQLBackupTimeout int not null constraint DF_BackupJob_SQLBackupTimeout default (60),
        CreationDate datetime not null constraint DF_BackupJob_CreationDate default (getutcdate()),
        CreationUsername nvarchar(256) null,
        CreationLoggedUserName nvarchar(256) null,
        ModifiedDate datetime not null constraint DF_BackupJob_ModifiedDate default (getutcdate()),
        ModifiedUsername nvarchar(256) null,
        ModifiedLoggedUserName nvarchar(256) null,
        constraint PK_BackupJob primary key clustered (ID asc)
    );